(setq require-final-newline t
      inhibit-local-variables t
      rmail-primary-inbox-list '("~/mbox" "/usr/spool/mail/$USER" "po:$USER"))

(autoload 'report-emacs-bug "emacsbug"
	  "Report a bug in Gnu emacs."
	  t)

(setq bug-gnu-emacs "netbsd-help@athena.mit.edu")

(autoload 'clu-mode "clu-mode"
	  "Load CLU mode."
	  t)
(setq auto-mode-alist (append auto-mode-alist '(("\\.clu$" . clu-mode))))

(autoload 'ispell-word "ispell"
	  "Check the spelling of a word in the buffer."
	  t)
(autoload 'ispell-region "ispell"
	  "Check the spelling of a region in the buffer."
	  t)
(autoload 'ispell-buffer "ispell"
	  "Check the spelling of the entire buffer."
	  t)

(autoload 'discuss "discuss"
	  "Enter discuss mode for emacs and list meetings."
	  t)

; Athena auto-save customizations

(defconst auto-save-main-directory
  "/usr/tmp/"
  "The root of the auto-save directory; nil means use old style.")

(defun make-auto-save-file-name ()
  "Return file name to use for auto-saves of current buffer.
Does not consider auto-save-visited-file-name; that is checked
before calling this function.
You can redefine this for customization.
See also auto-save-file-name-p."
  (if auto-save-main-directory
      (if buffer-file-name
	  (concat auto-save-main-directory
		  "#"
		  (user-real-uid)
		  "."
		  (auto-save-replace-slashes buffer-file-name)
		  "#")
	(concat auto-save-main-directory
		"#%"
		(user-real-uid)
		"."
		(auto-save-replace-slashes (buffer-name))
		"#"))
    (if buffer-file-name
	(concat (file-name-directory buffer-file-name)
		"#"
		(file-name-nondirectory buffer-file-name)
		"#")
      (expand-file-name (concat "#%" (buffer-name) "#")))))

(defun auto-save-replace-slashes (name)
  "Replace all slashes in NAME with bangs."
  (let ((pos 0) (len (length name)))
    (setq ourname (make-string len ? ))
    (while (< pos len)
      (if (= (aref name pos) ?/)
	  (aset ourname pos ?@)
	(aset ourname pos (aref name pos)))
      (setq pos (+ 1 pos)))
    ourname))

(setq mh-lib 
  (cond ((file-exists-p "/usr/athena/etc") "/usr/athena/etc/")
	((file-exists-p "/usr/new/lib/mh") "/usr/new/lib/mh/")
        ((file-exists-p "/usr/new/mh/lib") "/usr/new/mh/lib/")
        ((file-exists-p "/usr/local/lib/mh") "/usr/local/lib/mh/")
        (t "/usr/local/bin/mh/")))

(setq mh-progs
  (cond ((file-exists-p "/usr/athena/bin") "/usr/athena/bin/")
        ((file-exists-p "/usr/new/mh") "/usr/new/mh/")
	((file-exists-p "/usr/local/bin/mh") "/usr/local/bin/mh/")
	(t "/usr/local/mh/")))


; Set X10 standard mouse bindings
(defun x-set-x10-mouse-bindings ()
  "Change the mouse bindings to the X10 standard."
  (interactive)
  (define-key mouse-map x-button-right 'x-mouse-select)
  (define-key mouse-map x-button-left 'x-mouse-set-mark)
  (define-key mouse-map x-button-middle 'x-mouse-set-point))

; Set X11 standard mouse bindings
(defun x-set-x11-mouse-bindings ()
  "Change the mouse bindings to the X11 standard."
  (interactive)
  (define-key mouse-map x-button-right 'x-cut-text)
  (define-key mouse-map x-button-left 'x-mouse-set-point)
  (define-key mouse-map x-button-middle 'x-paste-text))

;; The filename excludes colons to avoid confusion when error message
;; starts with digits.
(defvar compilation-error-regexp
  "\\([^ :\n]+\\(: *\\|, line \\|(\\)[0-9]+\\)\\|\\([0-9]+ *of *[^ \n]+\\)\\|\\(\"[^ \n]+\",L[0-9]+\\)"
  "Regular expression for filename/linenumber in error in compilation log.")
