#ifndef WORDQ_H
#define WORDQ_H

typedef struct wordqueue_str {
    Int size;
    Int head;
    Int tail;
    short *data;
} Wordqueue;

#define WORDQUEUE_LENGTH(b)  ( (b)->tail - (b)->head >= 0 ?         \
			       (b)->tail - (b)->head      :         \
			       (b)->tail - (b)->head + (b)->size )

#define WORDQUEUE_SPACE(b)   ( (b)->size - WORDQUEUE_LENGTH(b) - 1 )
#define WORDQUEUE_EMPTY(b)   ( (b)->head - (b)->tail == 0 )
#define WORDQUEUE_FULL(b)    ( WORDQUEUE_SPACE(b) == 0 )

#include "wordq.pro"

#endif
