/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.Serializable;

public class EthernetAddress
implements Serializable,
Cloneable,
Comparable {
    private static final String kHexChars = "0123456789abcdefABCDEF";
    private final byte[] mAddress;

    public EthernetAddress(String string) throws NumberFormatException {
        byte[] byArray = this.mAddress = new byte[6];
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < 6) {
            int n4;
            if (n2 >= n) {
                if (n3 == 5) {
                    byArray[5] = 0;
                    break;
                }
                throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
            }
            char c = string.charAt(n2);
            ++n2;
            if (c == ':') {
                n4 = 0;
            } else {
                if (c >= '0' && c <= '9') {
                    n4 = c - 48;
                } else if (c >= 'a' && c <= 'f') {
                    n4 = c - 97 + 10;
                } else if (c >= 'A' && c <= 'F') {
                    n4 = c - 65 + 10;
                } else {
                    throw new NumberFormatException("Non-hex character '" + c + "'");
                }
                if (n2 < n) {
                    c = string.charAt(n2);
                    ++n2;
                    if (c != ':') {
                        n4 <<= 4;
                        if (c >= '0' && c <= '9') {
                            n4 |= c - 48;
                        } else if (c >= 'a' && c <= 'f') {
                            n4 |= c - 97 + 10;
                        } else if (c >= 'A' && c <= 'F') {
                            n4 |= c - 65 + 10;
                        } else {
                            throw new NumberFormatException("Non-hex character '" + c + "'");
                        }
                    }
                }
            }
            byArray[n3] = (byte)n4;
            if (c != ':') {
                if (n2 < n) {
                    if (string.charAt(n2) != ':') {
                        throw new NumberFormatException("Expected ':', got ('" + string.charAt(n2) + "')");
                    }
                    ++n2;
                } else if (n3 < 5) {
                    throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
                }
            }
            ++n3;
        }
    }

    public EthernetAddress(byte[] byArray) throws NumberFormatException {
        this.mAddress = new byte[6];
        if (byArray.length != 6) {
            throw new NumberFormatException("Ethernet address has to consist of 6 bytes");
        }
        int n = 0;
        while (n < 6) {
            this.mAddress[n] = byArray[n];
            ++n;
        }
    }

    public EthernetAddress(long l) {
        this.mAddress = new byte[6];
        int n = 0;
        while (n < 6) {
            this.mAddress[5 - n] = (byte)l;
            l >>>= 8;
            ++n;
        }
    }

    EthernetAddress() {
        this.mAddress = new byte[6];
        byte by = 0;
        int n = 0;
        while (n < 6) {
            this.mAddress[n] = by;
            ++n;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof EthernetAddress)) {
            return false;
        }
        byte[] byArray = ((EthernetAddress)object).mAddress;
        byte[] byArray2 = this.mAddress;
        int n = 0;
        while (n < 6) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int compareTo(Object object) {
        byte[] byArray = ((EthernetAddress)object).mAddress;
        byte[] byArray2 = this.mAddress;
        int n = 0;
        while (n < 6) {
            int n2 = (byArray2[n] & 0xFF) - (byArray[n] & 0xFF);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(17);
        byte[] byArray = this.mAddress;
        int n = 0;
        while (n < 6) {
            if (n > 0) {
                stringBuffer.append(":");
            }
            int n2 = byArray[n] & 0xFF;
            stringBuffer.append(kHexChars.charAt(n2 >> 4));
            stringBuffer.append(kHexChars.charAt(n2 & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }

    public byte[] asByteArray() {
        byte[] byArray = new byte[6];
        this.toByteArray(byArray);
        return byArray;
    }

    public byte[] toByteArray() {
        return this.asByteArray();
    }

    public void toByteArray(byte[] byArray) {
        this.toByteArray(byArray, 0);
    }

    public void toByteArray(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < 6) {
            byArray[n + n2] = this.mAddress[n2];
            ++n2;
        }
    }

    public long toLong() {
        byte[] byArray = this.mAddress;
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        int n2 = byArray[2] & 0xFF;
        int n3 = 3;
        while (n3 < 6) {
            n2 = n2 << 8 | byArray[n3] & 0xFF;
            ++n3;
        }
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static EthernetAddress valueOf(byte[] byArray) throws NumberFormatException {
        return new EthernetAddress(byArray);
    }

    public static EthernetAddress valueOf(int[] nArray) throws NumberFormatException {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        return new EthernetAddress(byArray);
    }

    public static EthernetAddress valueOf(String string) throws NumberFormatException {
        return new EthernetAddress(string);
    }

    public static EthernetAddress valueOf(long l) {
        return new EthernetAddress(l);
    }

    public static void main(String[] stringArray) {
        System.out.println("EthernetAddress.main, test:");
        System.out.println("---------------------------");
        long l = 0L;
        if (stringArray == null || stringArray.length == 0) {
            System.out.println("[no address passed, using a random address]");
            boolean bl = true;
            l = System.currentTimeMillis() ^ (long)(Math.random() * 4.294967296E9);
            stringArray = new String[]{new EthernetAddress(l).toString()};
        }
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                String string = stringArray[n];
                System.out.println("Address '" + string + "':");
                try {
                    EthernetAddress ethernetAddress = EthernetAddress.valueOf(string);
                    System.err.println("  Ok, comes out as '" + ethernetAddress.toString() + "'");
                    System.err.print("  Converting to long, result = ");
                    long l2 = ethernetAddress.toLong();
                    System.err.println("" + Long.toHexString(l2));
                    System.err.print("  Creating address from long, are equal: ");
                    EthernetAddress ethernetAddress2 = EthernetAddress.valueOf(l2);
                    if (!ethernetAddress2.equals(ethernetAddress)) {
                        System.err.println("no (FAIL)");
                        break;
                    }
                    System.err.println("yes (OK)");
                    System.err.println("  Converting to byte array.");
                    byte[] byArray = ethernetAddress.asByteArray();
                    System.err.print("  Creating address from byte[], are equal: ");
                    ethernetAddress2 = EthernetAddress.valueOf(byArray);
                    if (ethernetAddress2.equals(ethernetAddress)) {
                        System.err.println("yes (OK)");
                        break block6;
                    }
                    System.err.println("no (FAIL)");
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("  Fail: " + numberFormatException.toString());
                }
            }
            ++n;
        }
        System.out.println("---------------------------");
        System.out.println("Done.");
    }
}

