/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.doomdark.uuid.EthernetAddress;
import org.doomdark.uuid.TagURI;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDGenerator;

public class Jug {
    private static final HashMap mTypes = new HashMap();
    private static final HashMap mOptions;
    static /* synthetic */ Class class$org$doomdark$uuid$Jug;

    static void printUsage() {
        String string = (class$org$doomdark$uuid$Jug == null ? (class$org$doomdark$uuid$Jug = Jug.class$("org.doomdark.uuid.Jug")) : class$org$doomdark$uuid$Jug).getName();
        System.err.println("Usage: java " + string + " [options] type");
        System.err.println("Where options are:");
        System.err.println("  --count / -c <number>: will generate <number> UUIDs (default: 1");
        System.err.println("  --ethernet-address / -e <ether-address>: defines the ethernet address");
        System.err.println("    (in xx:xx:xx:xx:xx:xx notation, usually obtained using 'ifconfig' etc)");
        System.err.println("    to use with time-based UUID generation");
        System.err.println("  --help / -h: lists the usage (ie. what you see now)");
        System.err.println("  --name / -n: specifies");
        System.err.println("     o name for name-based UUID generation");
        System.err.println("     o 'information' part of tag-URI for tag-URI UUID generation");
        System.err.println("  --namespace / -s: specifies");
        System.err.println("    o the namespace (DNS or URL) for name-based UUID generation");
        System.err.println("    o 'authority' part of tag-URI for tag-URI UUID generation;");
        System.err.println("        (fully-qualified domain name, email address)");
        System.err.println("  --performance / -p: measure time it takes to generate UUID(s).");
        System.err.println("    [note that UUIDs are not printed out unless 'verbose' is also specified]");
        System.err.println("  --verbose / -v: lists additional information about UUID generation\n    (by default only UUIDs are printed out (to make it usable in scripts)");
        System.err.println("And type is one of:");
        System.err.println("  time-based / t: generate UUID based on current time and optional\n    location information (defined with -e option)");
        System.err.println("  random-based / r: generate UUID based on the default secure random number generator");
        System.err.println("  name-based / n: generate UUID based on the na the default secure random number generator");
    }

    private static void printMap(Map map, PrintStream printStream, boolean bl) {
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        int n2 = map.size();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            if (++n > 1) {
                if (n < n2) {
                    printStream.print(", ");
                } else {
                    printStream.print(" and ");
                }
            }
            if (bl) {
                printStream.print("--");
            }
            printStream.print(string);
            printStream.print(" (");
            if (bl) {
                printStream.print("-");
            }
            printStream.print(string2);
            printStream.print(")");
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        char c;
        if (stringArray.length == 0) {
            Jug.printUsage();
            return;
        }
        int n = stringArray.length;
        String string = stringArray[n - 1];
        boolean bl = false;
        int n2 = 1;
        String string2 = null;
        String string3 = null;
        EthernetAddress ethernetAddress = null;
        boolean bl2 = false;
        --n;
        String string4 = (String)mTypes.get(string);
        if (string4 == null) {
            if (!mTypes.containsValue(string)) {
                System.err.println("Unrecognized UUID generation type '" + string + "'; currently available ones are:");
                Jug.printMap(mTypes, System.err, false);
                System.err.println();
                System.exit(1);
            }
        } else {
            string = string4;
        }
        int n3 = 0;
        while (n3 < n) {
            String string5 = stringArray[n3];
            if (string5.length() == 0 || string5.charAt(0) != '-') {
                System.err.println("Unrecognized option '" + string5 + "' (missing leading hyphen?), exiting.");
                System.exit(1);
            }
            c = '\u0000';
            if (string5.startsWith("--")) {
                object2 = (String)mOptions.get(string5.substring(2));
                if (object2 != null) {
                    c = ((String)object2).charAt(0);
                }
            } else if (mOptions.containsValue(string5.substring(1))) {
                c = string5.charAt(1);
            }
            if (c == '\u0000') {
                System.err.println("Unrecognized option '" + string5 + "'; exiting.");
                System.err.print("[options currently available are: ");
                Jug.printMap(mOptions, System.err, true);
                System.err.println("]");
                System.exit(1);
            }
            try {
                switch (c) {
                    case 'c': {
                        object2 = stringArray[++n3];
                        try {
                            n2 = Integer.parseInt((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Invalid number argument for option '" + string5 + "', exiting.");
                            System.exit(1);
                        }
                        if (n2 >= 1) break;
                        System.err.println("Invalid number argument for option '" + string5 + "'; negative numbers not allowed, ignoring (defaults to 1).");
                        break;
                    }
                    case 'e': {
                        object2 = stringArray[++n3];
                        try {
                            ethernetAddress = EthernetAddress.valueOf((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Invalid ethernet address for option '" + string5 + "', error: " + numberFormatException.toString());
                            System.exit(1);
                        }
                        break;
                    }
                    case 'h': {
                        Jug.printUsage();
                        return;
                    }
                    case 'n': {
                        string2 = stringArray[++n3];
                        break;
                    }
                    case 'p': {
                        bl2 = true;
                        break;
                    }
                    case 's': {
                        string3 = stringArray[++n3];
                        break;
                    }
                    case 'v': {
                        bl = true;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.err.println("Missing argument for option '" + string5 + "', exiting.");
                System.exit(1);
            }
            ++n3;
        }
        boolean bl3 = false;
        c = string.charAt(0);
        object2 = null;
        TagURI tagURI = null;
        UUIDGenerator uUIDGenerator = UUIDGenerator.getInstance();
        boolean bl4 = false;
        switch (c) {
            case 't': {
                bl4 = true;
                if (ethernetAddress != null) break;
                if (bl) {
                    System.out.print("(no address specified, generating dummy address: ");
                }
                ethernetAddress = uUIDGenerator.getDummyAddress();
                if (!bl) break;
                System.out.print(ethernetAddress.toString());
                System.out.println(")");
                break;
            }
            case 'r': {
                bl4 = true;
                if (!bl) break;
                Object object3 = uUIDGenerator.getRandomNumberGenerator();
                System.out.print("(using the default random generator, info = '" + ((SecureRandom)object3).getProvider().getInfo() + "')");
                break;
            }
            case 'U': {
                bl3 = true;
            }
            case 'n': 
            case 'u': {
                Object object3;
                if (string2 == null) {
                    System.err.println("--name-space (-s) - argument missing when using method that requires it, exiting.");
                    System.exit(1);
                }
                if (string2 == null) {
                    System.err.println("--name (-n) - argument missing when using method that requires it, exiting.");
                    System.exit(1);
                }
                if (c == 'n') {
                    object3 = string3;
                    if ((string3 = string3.toLowerCase()).equals("url")) {
                        string3 = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
                    } else if (string3.equals("dns")) {
                        string3 = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
                    } else {
                        System.err.println("Unrecognized namespace '" + (String)object3 + "'; only DNS and URL allowed for name-based generation.");
                        System.exit(1);
                    }
                    try {
                        object2 = new UUID(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Internal error: " + numberFormatException.toString());
                        System.err.println("Exiting.");
                        System.exit(1);
                    }
                } else if (!bl3) {
                    tagURI = new TagURI(string3, string2, null);
                    if (bl) {
                        System.out.println("(Using tagURI '" + tagURI.toString() + "')");
                    }
                }
                if (!bl) break;
                object3 = uUIDGenerator.getHashAlgorithm();
                System.out.println("(Using the default hash algorithm, type = '" + ((MessageDigest)object3).getAlgorithm() + "', provider info - '" + ((MessageDigest)object3).getProvider().getInfo() + "')");
            }
        }
        if (bl) {
            System.out.println();
        }
        long l = 0L;
        if (bl2) {
            if (bl4) {
                if (bl) {
                    System.out.println("(initializing random number generator before UUID generation so that performance measurements are not skewed due to one-time init costs)");
                }
                SecureRandom secureRandom = uUIDGenerator.getRandomNumberGenerator();
                object = new byte[1];
                secureRandom.nextBytes((byte[])object);
                if (bl) {
                    System.out.println("(random number generator initialized ok)");
                }
            }
            l = System.currentTimeMillis();
        }
        int n4 = 0;
        while (n4 < n2) {
            object = null;
            switch (c) {
                case 't': {
                    object = uUIDGenerator.generateTimeBasedUUID(ethernetAddress);
                    break;
                }
                case 'r': {
                    object = uUIDGenerator.generateRandomBasedUUID();
                    break;
                }
                case 'n': {
                    object = uUIDGenerator.generateNameBasedUUID((UUID)object2, string2);
                    break;
                }
                case 'U': 
                case 'u': {
                    if (bl3) {
                        tagURI = new TagURI(string3, string2, Calendar.getInstance());
                        if (bl) {
                            System.out.println("(Using tagURI '" + tagURI.toString() + "')");
                        }
                    }
                    object = uUIDGenerator.generateTagURIBasedUUID(tagURI);
                }
            }
            if (bl) {
                System.out.print("UUID: ");
            }
            if (!bl2 || bl) {
                System.out.println(((UUID)object).toString());
            }
            ++n4;
        }
        if (bl) {
            System.out.println("Done.");
        }
        if (bl2) {
            l = System.currentTimeMillis() - l;
            long l2 = (l * 10L + (long)(n2 / 2)) / (long)n2;
            System.out.println("Performance: took " + l + " milliseconds to generate (and print out) " + n2 + " UUIDs; average being " + l2 / 10L + "." + l2 % 10L + " msec.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mTypes.put("time-based", "t");
        mTypes.put("random-based", "r");
        mTypes.put("name-based", "n");
        mTypes.put("tag-uri-no-timestamp", "u");
        mTypes.put("tag-uri-with-timestamp", "U");
        mOptions = new HashMap();
        mOptions.put("count", "c");
        mOptions.put("ethernet-address", "e");
        mOptions.put("help", "h");
        mOptions.put("namespace", "s");
        mOptions.put("name", "n");
        mOptions.put("performance", "p");
        mOptions.put("verbose", "v");
    }
}

