/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.doomdark.uuid.EthernetAddress;

public class NativeInterfaces {
    private static final String sDefaultLibSubdir = "jug-native";
    private static File sLibDir = null;
    private static boolean mNativeLoaded = false;

    protected static synchronized void setLibDir(File file) {
        sLibDir = file;
    }

    protected static synchronized void checkLoad() {
        if (!mNativeLoaded) {
            String string = System.getProperty("os.name").trim().toLowerCase();
            String string2 = System.getProperty("os.arch").trim().toLowerCase();
            String string3 = null;
            String string4 = null;
            if (string.indexOf("windows") >= 0) {
                string3 = "Win";
            } else if (string.indexOf("linux") >= 0) {
                string3 = "Linux";
            } else if (string.indexOf("solaris") >= 0 || string.indexOf("sunos") >= 0) {
                string3 = "Solaris";
            } else {
                throw new Error("No native ethernet access library for OS '" + string + "'.");
            }
            if (string2.indexOf("x86") >= 0 || string2.indexOf("sparc") >= 0) {
                string4 = string2;
            } else {
                if (string2.indexOf("powerpc") >= 0 || string2.indexOf("ppc") >= 0) {
                    throw new Error("No native ethernet access library yet available on PowerPC architecture");
                }
                if (string2.indexOf("86") >= 0 || string2.indexOf("amd") >= 0) {
                    string4 = "x86";
                } else {
                    throw new Error("No native ethernet access library for hardware platform with value '" + string2 + "'.");
                }
            }
            String string5 = string3 + "_" + string4 + "_" + "EtherAddr";
            String string6 = System.mapLibraryName(string5);
            String string7 = "Tried to load library '" + string5 + "' (filename assumed to be '" + string6 + "'";
            try {
                File file;
                if (sLibDir == null) {
                    file = new File(sDefaultLibSubdir);
                    file = new File(file, string6);
                } else {
                    file = new File(sLibDir, string6);
                }
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    throw new Error(string7 + ": checking existence of '" + file.getAbsolutePath() + "': " + iOException.toString());
                }
                System.load(file.getAbsolutePath());
            }
            catch (SecurityException securityException) {
                throw new Error(string7 + ": error; " + securityException.toString());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new Error(string7 + ": error; " + unsatisfiedLinkError.toString());
            }
            mNativeLoaded = true;
        }
    }

    public static EthernetAddress getPrimaryInterface() {
        NativeInterfaces.checkLoad();
        try {
            com.ccg.net.ethernet.EthernetAddress ethernetAddress = com.ccg.net.ethernet.EthernetAddress.getPrimaryAdapter();
            if (ethernetAddress != null) {
                return new EthernetAddress(ethernetAddress.getBytes());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Error(unsatisfiedLinkError.toString());
        }
        return null;
    }

    public static EthernetAddress[] getAllInterfaces() {
        EthernetAddress[] ethernetAddressArray = null;
        NativeInterfaces.checkLoad();
        try {
            Collection collection = com.ccg.net.ethernet.EthernetAddress.getAllAdapters();
            ethernetAddressArray = new EthernetAddress[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                com.ccg.net.ethernet.EthernetAddress ethernetAddress = (com.ccg.net.ethernet.EthernetAddress)iterator.next();
                ethernetAddressArray[n] = new EthernetAddress(ethernetAddress.getBytes());
                ++n;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Error(unsatisfiedLinkError.toString());
        }
        return ethernetAddressArray;
    }

    public static void main(String[] stringArray) {
        System.out.println("Trying to access primary ethernet interface:");
        try {
            EthernetAddress ethernetAddress = NativeInterfaces.getPrimaryInterface();
            System.out.println("Ok, the interface MAC-address is: " + ethernetAddress.toString());
        }
        catch (Throwable throwable) {
            System.out.println("Failed, error given: " + throwable.toString());
        }
    }
}

