/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.xml.security.algorithms.encryption.helper.InvalidCipherTextException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.PRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TripleDESWrapper {
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    byte[] digest;
    byte[] iv;
    Cipher _cipher;
    MessageDigest _digest;

    public byte[] wrap(byte[] byArray, Key key, byte[] byArray2) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, XMLSecurityException {
        try {
            byte[] byArray3 = this.calculateCMSKeyChecksum(byArray);
            byte[] byArray4 = new byte[byArray.length + byArray3.length];
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length, byArray3.length);
            byte[] byArray5 = new byte[byArray4.length];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            int n = byArray4.length % this._cipher.getBlockSize();
            if (n != 0) {
                throw new IllegalStateException("Not multiple of block length: " + byArray4.length + " % " + this._cipher.getBlockSize() + " = " + n);
            }
            if (byArray2 == null) {
                byArray2 = PRNG.createBytes(8);
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            this._cipher.init(1, key, ivParameterSpec);
            Object object = new ByteArrayOutputStream();
            byte[] byArray6 = this._cipher.update(byArray5);
            if (byArray6 != null) {
                ((OutputStream)object).write(byArray6);
            }
            if ((byArray6 = this._cipher.doFinal()) != null) {
                ((OutputStream)object).write(byArray6);
            }
            System.arraycopy(((ByteArrayOutputStream)object).toByteArray(), 0, byArray5, 0, byArray5.length);
            object = new byte[byArray2.length + byArray5.length];
            System.arraycopy(byArray2, 0, object, 0, byArray2.length);
            System.arraycopy(byArray5, 0, object, byArray2.length, byArray5.length);
            byArray6 = new byte[((Object)object).length];
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                byArray6[n2] = (byte)object[((Object)object).length - (n2 + 1)];
                ++n2;
            }
            IvParameterSpec ivParameterSpec2 = new IvParameterSpec(IV2);
            this._cipher.init(1, key, ivParameterSpec2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray7 = this._cipher.update(byArray6);
            if (byArray7 != null) {
                byteArrayOutputStream.write(byArray7);
            }
            if ((byArray7 = this._cipher.doFinal()) != null) {
                byteArrayOutputStream.write(byArray7);
            }
            System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray6, 0, byArray6.length);
            return byArray6;
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("empty", iOException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLSecurityException("empty", badPaddingException);
        }
    }

    public byte[] unwrap(byte[] byArray, Key key) throws InvalidCipherTextException, XMLSecurityException {
        try {
            if (byArray == null) {
                throw new InvalidCipherTextException("Null pointer as ciphertext");
            }
            if (byArray.length % this._cipher.getBlockSize() != 0) {
                throw new InvalidCipherTextException("Ciphertext not multiple of " + this._cipher.getBlockSize());
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(IV2);
            this._cipher.init(2, key, ivParameterSpec);
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            Object object = new ByteArrayOutputStream();
            byte[] byArray3 = this._cipher.update(byArray2);
            if (byArray3 != null) {
                ((OutputStream)object).write(byArray3);
            }
            if ((byArray3 = this._cipher.doFinal()) != null) {
                ((OutputStream)object).write(byArray3);
            }
            System.arraycopy(((ByteArrayOutputStream)object).toByteArray(), 0, byArray2, 0, byArray2.length);
            object = new byte[byArray2.length];
            int n = 0;
            while (n < byArray2.length) {
                object[n] = byArray2[byArray2.length - (n + 1)];
                ++n;
            }
            IvParameterSpec ivParameterSpec2 = new IvParameterSpec((byte[])object, 0, 8);
            byte[] byArray4 = new byte[((Object)object).length - 8];
            System.arraycopy(object, 8, byArray4, 0, ((Object)object).length - 8);
            this._cipher.init(2, key, ivParameterSpec2);
            byte[] byArray5 = new byte[byArray4.length];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            Object object2 = new ByteArrayOutputStream();
            byte[] byArray6 = this._cipher.update(byArray5);
            if (byArray6 != null) {
                ((OutputStream)object2).write(byArray6);
            }
            if ((byArray6 = this._cipher.doFinal()) != null) {
                ((OutputStream)object2).write(byArray6);
            }
            System.arraycopy(((ByteArrayOutputStream)object2).toByteArray(), 0, byArray5, 0, byArray5.length);
            object2 = new byte[byArray5.length - 8];
            byArray6 = new byte[8];
            System.arraycopy(byArray5, 0, object2, 0, byArray5.length - 8);
            System.arraycopy(byArray5, byArray5.length - 8, byArray6, 0, 8);
            if (!this.checkCMSKeyChecksum((byte[])object2, byArray6)) {
                throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
            }
            return object2;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw invalidCipherTextException;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw xMLSecurityException;
        }
        catch (Exception exception) {
            throw new XMLSecurityException("empty", exception);
        }
    }

    private final byte[] calculateCMSKeyChecksum(byte[] byArray) {
        this._digest.reset();
        this._digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = this._digest.digest();
        System.arraycopy(byArray3, 0, byArray2, 0, 8);
        return byArray2;
    }

    private final boolean checkCMSKeyChecksum(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.calculateCMSKeyChecksum(byArray);
        if (byArray2.length != byArray3.length) {
            return false;
        }
        int n = 0;
        while (n != byArray2.length) {
            if (byArray2[n] != byArray3[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final /* synthetic */ void this() {
        this.digest = new byte[20];
    }

    public TripleDESWrapper(Cipher cipher, MessageDigest messageDigest) {
        this.this();
        this._cipher = cipher;
        this._digest = messageDigest;
    }
}

