/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.io.IOException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.EncryptionElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Transforms
extends EncryptionElementProxy {
    public void addTransform(String string) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, string);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public void addTransform(String string, Element element) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, string, element);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public void addTransform(String string, NodeList nodeList) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, string, nodeList);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    private final void addTransform(Transform transform) {
        this._constructionElement.appendChild(transform.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignatureInput performDecryptionTransforms(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            int n = 0;
            while (n < this.getLength()) {
                Transform transform = this.item(n);
                xMLSignatureInput = transform.performTransform(xMLSignatureInput);
                ++n;
            }
            return xMLSignatureInput;
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
    }

    public int getLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Transform");
    }

    private final Transform item(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "Transform");
        if (element == null) {
            return null;
        }
        return new Transform(element, this._baseURI);
    }

    public String getBaseLocalName() {
        return "Transforms";
    }

    public Transforms(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public Transforms(Element element, String string) throws XMLSecurityException {
        super(element, string);
        int n = this.getLength();
        if (n == 0) {
            Object[] objectArray = new Object[]{"ds:Transform", "xenc:Transforms"};
            throw new XMLSecurityException("xml.WrongContent", objectArray);
        }
    }
}

