/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.provider;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.provider.KeyBaseType;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CertificateElement
extends KeyBaseType {
    public void setJCAType(Certificate certificate) {
        if (this._state == 0) {
            this._constructionElement.setAttributeNS(null, "JCAType", certificate.getType());
        }
    }

    public String getJCAType() {
        return this._constructionElement.getAttributeNS(null, "JCAType");
    }

    public Certificate getCertificate() throws XMLSecurityException, CertificateException {
        Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
        if (element == null) {
            return null;
        }
        XMLX509Certificate xMLX509Certificate = new XMLX509Certificate(element, this._baseURI);
        CertificateFactory certificateFactory = CertificateFactory.getInstance(this.getJCAType());
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(xMLX509Certificate.getCertificateBytes()));
        return certificate;
    }

    public String getBaseLocalName() {
        return "Certificate";
    }

    public CertificateElement(Document document, String string, Certificate certificate) throws XMLSecurityException {
        super(document, string);
        try {
            XMLX509Certificate xMLX509Certificate = new XMLX509Certificate(document, certificate.getEncoded());
            this._constructionElement.appendChild(xMLX509Certificate.getElement());
            XMLUtils.addReturnToElement(this);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new XMLSecurityException("empty", certificateEncodingException);
        }
        this.setJCAType(certificate);
    }

    public CertificateElement(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }
}

