/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315OmitComments;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XMLSignatureInput {
    InputStream _inputOctetStreamProxy;
    Set _inputNodeSet;
    CachedXPathAPI _cxpathAPI;
    private String _MIMEType;
    private String _SourceURI;

    public Set getNodeSet() throws ParserConfigurationException, IOException, SAXException, CanonicalizationException, InvalidCanonicalizerException {
        if (this.isNodeSet()) {
            return this._inputNodeSet;
        }
        if (this.isOctetStream()) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
                Document document = documentBuilder.parse(this.getOctetStream());
                XMLUtils.circumventBug2650(document);
                NodeList nodeList = this._cxpathAPI.selectNodeList((Node)document, "(.//. | .//@* | .//namespace::*)");
                return XMLUtils.convertNodelistToSet(nodeList);
            }
            catch (TransformerException transformerException) {
                throw new CanonicalizationException("generic.EmptyMessage", transformerException);
            }
            catch (SAXException sAXException) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write("<container>".getBytes());
                byteArrayOutputStream.write(this.getBytes());
                byteArrayOutputStream.write("</container>".getBytes());
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
                XMLUtils.circumventBug2650(document);
                try {
                    NodeList nodeList = this._cxpathAPI.selectNodeList((Node)document, "(//. | //@* | //namespace::*)[not(self::node()=/) and not(self::node=/container)]");
                    return XMLUtils.convertNodelistToSet(nodeList);
                }
                catch (TransformerException transformerException) {
                    throw new CanonicalizationException("generic.EmptyMessage", transformerException);
                }
            }
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        if (this.isOctetStream()) {
            this._inputOctetStreamProxy.reset();
            return this._inputOctetStreamProxy;
        }
        if (this.isNodeSet()) {
            Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (this._inputNodeSet.size() == 0) {
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            try {
                Set set = this.getNodeSet();
                byte[] byArray = canonicalizer20010315OmitComments.engineCanonicalizeXPathNodeSet(set);
                byteArrayOutputStream.write(byArray);
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (SAXException sAXException) {
                throw new CanonicalizationException("empty", sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new CanonicalizationException("empty", parserConfigurationException);
            }
        }
        throw new RuntimeException("getOctetStream() called but no input data present");
    }

    public byte[] getBytes() throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        InputStream inputStream = this.getOctetStream();
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        if (n != byArray.length) {
            throw new IOException("Not enough bytes read");
        }
        return byArray;
    }

    public boolean isNodeSet() {
        boolean bl = false;
        if (this._inputOctetStreamProxy == null && this._inputNodeSet != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isOctetStream() {
        boolean bl = false;
        if (this._inputOctetStreamProxy != null && this._inputNodeSet == null) {
            bl = true;
        }
        return bl;
    }

    public boolean isInitialized() {
        boolean bl = false;
        if (this.isOctetStream() || this.isNodeSet()) {
            bl = true;
        }
        return bl;
    }

    public String getMIMEType() {
        return this._MIMEType;
    }

    public void setMIMEType(String string) {
        this._MIMEType = string;
    }

    public String getSourceURI() {
        return this._SourceURI;
    }

    public void setSourceURI(String string) {
        this._SourceURI = string;
    }

    public CachedXPathAPI getCachedXPathAPI() {
        return this._cxpathAPI;
    }

    public String toString() {
        if (this.isNodeSet()) {
            try {
                return "XMLSignatureInput/NodeSet/" + this._inputNodeSet.size() + " nodes/" + this.getSourceURI();
            }
            catch (Exception exception) {
                return "XMLSignatureInput/NodeSet//" + this.getSourceURI();
            }
        }
        try {
            return "XMLSignatureInput/OctetStream/" + this.getBytes().length + " octets/" + this.getSourceURI();
        }
        catch (Exception exception) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    public String getHTMLRepresentation(Set set) throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this, set);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    private final /* synthetic */ void this() {
        this._inputOctetStreamProxy = null;
        this._inputNodeSet = null;
        this._MIMEType = null;
        this._SourceURI = null;
    }

    public XMLSignatureInput(byte[] byArray) {
        this.this();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this._inputOctetStreamProxy = new ByteArrayInputStream(byArray2);
        this._cxpathAPI = new CachedXPathAPI();
    }

    public XMLSignatureInput(InputStream inputStream) throws IOException {
        this(JavaUtils.getBytesFromStream(inputStream));
        inputStream = null;
    }

    public XMLSignatureInput(String string) {
        this(string.getBytes());
    }

    public XMLSignatureInput(String string, String string2) throws UnsupportedEncodingException {
        this(string.getBytes(string2));
    }

    public XMLSignatureInput(Node node, CachedXPathAPI cachedXPathAPI) throws TransformerException {
        this.this();
        this._cxpathAPI = cachedXPathAPI;
        Document document = XMLUtils.getOwnerDocument(node);
        XMLUtils.circumventBug2650(document);
        NodeList nodeList = this._cxpathAPI.selectNodeList(node, "(.//. | .//@* | .//namespace::*)");
        this._inputNodeSet = XMLUtils.convertNodelistToSet(nodeList);
    }

    public XMLSignatureInput(Node node) throws TransformerException {
        this(node, new CachedXPathAPI());
    }

    public XMLSignatureInput(Set set, CachedXPathAPI cachedXPathAPI) {
        this.this();
        this._inputNodeSet = set;
        this._cxpathAPI = cachedXPathAPI;
    }

    public XMLSignatureInput(Set set) {
        this(set, new CachedXPathAPI());
    }

    public XMLSignatureInput(NodeList nodeList) {
        this(XMLUtils.convertNodelistToSet(nodeList), new CachedXPathAPI());
    }

    public XMLSignatureInput(NodeList nodeList, CachedXPathAPI cachedXPathAPI) {
        this(XMLUtils.convertNodelistToSet(nodeList), cachedXPathAPI);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class XMLSignatureInputDebugger {
        public static final String HTMLPrefix = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n";
        public static final String HTMLSuffix = "</pre></body></html>";
        public static final String HTMLExcludePrefix = "<span class=\"EXCLUDED\">";
        public static final String HTMLExcludeSuffix = "</span>";
        public static final String HTMLIncludePrefix = "<span class=\"INCLUDED\">";
        public static final String HTMLIncludeSuffix = "</span>";
        public static final String HTMLIncludedInclusiveNamespacePrefix = "<span class=\"INCLUDEDINCLUSIVENAMESPACE\">";
        public static final String HTMLIncludedInclusiveNamespaceSuffix = "</span>";
        public static final String HTMLExcludedInclusiveNamespacePrefix = "<span class=\"EXCLUDEDINCLUSIVENAMESPACE\">";
        public static final String HTMLExcludedInclusiveNamespaceSuffix = "</span>";
        private static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
        private static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
        private static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
        private Set _xpathNodeSet;
        private Set _inclusiveNamespaces;
        private Document _doc;
        private Element _documentElement;
        private Writer _writer;

        public String getHTMLRepresentation() throws XMLSignatureException {
            if (this._xpathNodeSet == null || this._xpathNodeSet.size() == 0) {
                return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n<blink>no node set, sorry</blink></pre></body></html>";
            }
            Node node = (Node)this._xpathNodeSet.iterator().next();
            this._doc = XMLUtils.getOwnerDocument(node);
            this._documentElement = this._doc.getDocumentElement();
            try {
                this._writer = new StringWriter();
                this.canonicalizeXPathNodeSet(this._doc);
                this._writer.close();
                String string = this._writer.toString();
                Object var2_4 = null;
                this._xpathNodeSet = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return string;
            }
            catch (IOException iOException) {
                try {
                    throw new XMLSignatureException("empty", iOException);
                }
                catch (Throwable throwable) {
                    Object var2_5 = null;
                    this._xpathNodeSet = null;
                    this._doc = null;
                    this._documentElement = null;
                    this._writer = null;
                    throw throwable;
                }
            }
        }

        private final void canonicalizeXPathNodeSet(Node node) throws XMLSignatureException, IOException {
            short s = node.getNodeType();
            boolean bl = this._xpathNodeSet.contains(node);
            switch (s) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 11: 
                case 12: {
                    throw new XMLSignatureException("empty");
                }
                case 9: {
                    this._writer.write(HTMLPrefix);
                    Node node2 = node.getFirstChild();
                    while (node2 != null) {
                        this.canonicalizeXPathNodeSet(node2);
                        node2 = node2.getNextSibling();
                    }
                    this._writer.write(HTMLSuffix);
                    break;
                }
                case 8: {
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    int n = this.getPositionRelativeToDocumentElement(node);
                    if (n == 1) {
                        this._writer.write("\n");
                    }
                    this.outputCommentToWriter((Comment)node);
                    if (n == -1) {
                        this._writer.write("\n");
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 7: {
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    int n = this.getPositionRelativeToDocumentElement(node);
                    if (n == 1) {
                        this._writer.write("\n");
                    }
                    this.outputPItoWriter((ProcessingInstruction)node);
                    if (n == -1) {
                        this._writer.write("\n");
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 3: 
                case 4: {
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this.outputTextToWriter(node.getNodeValue());
                    Node node3 = node.getNextSibling();
                    while (node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4)) {
                        this.outputTextToWriter(node3.getNodeValue());
                        node3 = node3.getNextSibling();
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 1: {
                    Element element = (Element)node;
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&lt;");
                    this._writer.write(element.getTagName());
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                    } else {
                        this._writer.write("</span>");
                    }
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    Object[] objectArray = new Object[n];
                    int n2 = 0;
                    while (n2 < n) {
                        objectArray[n2] = namedNodeMap.item(n2);
                        ++n2;
                    }
                    Object[] objectArray2 = C14nHelper.sortAttributes(objectArray);
                    int n3 = 0;
                    while (n3 < n) {
                        Attr attr = (Attr)objectArray2[n3];
                        boolean bl2 = this._xpathNodeSet.contains(attr);
                        boolean bl3 = this._inclusiveNamespaces.contains(attr.getName());
                        if (bl2) {
                            if (bl3) {
                                this._writer.write(HTMLIncludedInclusiveNamespacePrefix);
                            } else {
                                this._writer.write(HTMLIncludePrefix);
                            }
                        } else if (bl3) {
                            this._writer.write(HTMLExcludedInclusiveNamespacePrefix);
                        } else {
                            this._writer.write(HTMLExcludePrefix);
                        }
                        this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                        if (bl2) {
                            if (bl3) {
                                this._writer.write("</span>");
                            } else {
                                this._writer.write("</span>");
                            }
                        } else if (bl3) {
                            this._writer.write("</span>");
                        } else {
                            this._writer.write("</span>");
                        }
                        ++n3;
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&gt;");
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                    } else {
                        this._writer.write("</span>");
                    }
                    Node node4 = node.getFirstChild();
                    while (node4 != null) {
                        this.canonicalizeXPathNodeSet(node4);
                        node4 = node4.getNextSibling();
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&lt;/");
                    this._writer.write(element.getTagName());
                    this._writer.write("&gt;");
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                }
            }
        }

        private final int getPositionRelativeToDocumentElement(Node node) {
            if (node == null) {
                return 0;
            }
            Document document = node.getOwnerDocument();
            if (node.getParentNode() != document) {
                return 0;
            }
            Element element = document.getDocumentElement();
            if (element == null) {
                return 0;
            }
            if (element == node) {
                return 0;
            }
            Node node2 = node;
            while (node2 != null) {
                if (node2 == element) {
                    return -1;
                }
                node2 = node2.getNextSibling();
            }
            return 1;
        }

        private final void outputAttrToWriter(String string, String string2) throws IOException {
            this._writer.write(" ");
            this._writer.write(string);
            this._writer.write("=\"");
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string2.charAt(n2);
                switch (c) {
                    case '&': {
                        this._writer.write("&amp;amp;");
                        break;
                    }
                    case '<': {
                        this._writer.write("&amp;lt;");
                        break;
                    }
                    case '\"': {
                        this._writer.write("&amp;quot;");
                        break;
                    }
                    case '\t': {
                        this._writer.write("&amp;#x9;");
                        break;
                    }
                    case '\n': {
                        this._writer.write("&amp;#xA;");
                        break;
                    }
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++n2;
            }
            this._writer.write("\"");
        }

        private final void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
            int n;
            if (processingInstruction == null) {
                return;
            }
            this._writer.write("&lt;?");
            String string = processingInstruction.getTarget();
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                n = string.charAt(n3);
                switch (n) {
                    case 13: {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(n);
                    }
                }
                ++n3;
            }
            String string2 = processingInstruction.getData();
            n2 = string2.length();
            if (string2 != null && n2 > 0) {
                this._writer.write(" ");
                n = 0;
                while (n < n2) {
                    char c = string2.charAt(n);
                    switch (c) {
                        case '\r': {
                            this._writer.write("&amp;#xD;");
                            break;
                        }
                        default: {
                            this._writer.write(c);
                        }
                    }
                    ++n;
                }
            }
            this._writer.write("?&gt;");
        }

        private final void outputCommentToWriter(Comment comment) throws IOException {
            if (comment == null) {
                return;
            }
            this._writer.write("&lt;!--");
            String string = comment.getData();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++n2;
            }
            this._writer.write("--&gt;");
        }

        private final void outputTextToWriter(String string) throws IOException {
            if (string == null) {
                return;
            }
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '&': {
                        this._writer.write("&amp;amp;");
                        break;
                    }
                    case '<': {
                        this._writer.write("&amp;lt;");
                        break;
                    }
                    case '>': {
                        this._writer.write("&amp;gt;");
                        break;
                    }
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++n2;
            }
        }

        private final /* synthetic */ void this() {
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
        }

        private XMLSignatureInputDebugger() {
            this.this();
        }

        public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput2) throws XMLSignatureException {
            this.this();
            this._xpathNodeSet = !xMLSignatureInput2.isNodeSet() ? null : xMLSignatureInput2._inputNodeSet;
        }

        public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput2, Set set) throws XMLSignatureException {
            this(xMLSignatureInput2);
            this._inclusiveNamespaces = set;
        }
    }
}

