/**********************************************************************
 *  setuser.c -- intialize Athena Login session structure
 *
 * Copyright 1994 by the Massachusetts Institute of Technology
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 **********************************************************************/
#include <mit-copyright.h>

#include <AL/AL.h>
#include <AL/etale.h>
#include <unistd.h>
#include <pwd.h>
#include <hesiod.h>
#include <string.h>
#include <stdio.h>
#include <sys/param.h>
#ifdef BSD4_4
#include <paths.h>
#endif

#ifndef _PATH_SHELLCVT
#define _PATH_SHELLCVT "/etc/athena/shellcvt"
#endif

#ifndef _PATH_CSHELL
#define _PATH_CSHELL "/bin/csh"
#endif

/* Fill in elements of Athena login session */

long
ALsetUser(ALsession session, char *uname, ALflag_t initial_flags)
{
  struct passwd *pw;

  initialize_ale_error_table();		/* For com_err(). */
  initialize_alw_error_table();
  hes_init();				/* For hes_resolve_r(). */
  ALinitUtmp(session);

  memset(session, 0, sizeof(*session));
  session->flags = initial_flags;
  /* set flags according to noattach, nocreate, noremote, nologin */
  if (ALfileExists(ALfileNOLOGIN)) ALflagSet(session, ALhaveNOLOGIN);
  if (ALfileExists(ALfileNOCREATE)) ALflagSet(session, ALhaveNOCREATE);
  if (ALfileExists(ALfileNOREMOTE)) ALflagSet(session, ALhaveNOREMOTE);
  if (ALfileExists(ALfileNOATTACH)) ALflagSet(session, ALhaveNOATTACH);
  if (ALfileExists(ALfileNOCRACK)) ALflagSet(session, ALhaveNOCRACK);

  /* find user in passwd file */
  pw = ALgetpwnam_r(uname, &session->pwd, session->pwbuf, ALlengthPasswdBuf);

#ifndef NO_HESIOD
  if (!pw)
    {
      /* get passwd information from hesiod */
      if (hes_getpwnam_r(uname, &session->pwd, session->pwbuf,
			 ALlengthPasswdBuf) != HES_ER_OK)
	ALreturnError(session, ALerrUserUnknown, uname);

      /* disallow hesiod entries with uid==0 */
      if (!ALpw_uid(session))
	ALreturnError(session, ALerrIllegalHesiod, uname);

      /* Remember that we got info through hesiod */
      ALflagSet(session, ALdidGetHesiodPasswd);
    }
#else /* NO_HESIOD */
  if (!pw)
    ALreturnError(session, ALerrUserUnknown, uname);
#endif
  
  return 0L;
}

