#
# The portable part of the make
# Assumes that CC is set to either "cc" or "gcc"
#
# Also assumes gcc supports -G option which may in fact not be the
# case with gcc versions earlier then 2.6.3 (which is what I'm
# using).
#

gccFLAGS = -fPIC

# IFF you're using the 4.0 Sun C compiler, then you'll need
# to use the ccFLAGS assignment with -xildoff since dynodump
# doesn't work with the incremental linker.

#ccFLAGS = -KPIC -xildoff
ccFLAGS = -KPIC

# If you want to build for UltraSPARC only AND you're using the 4.0
# Sun C compiler, play with the following line (warning the resultant
# binaries will not run on anything lower):

#sun4uCFLAGS = -xarch=v8plusa -xchip=ultra

INCLUDES = -I$(ARCH)

CFLAGS = $($(CC)FLAGS) $($(ARCH)CFLAGS) $(COPTFLAG) $(INCLUDES)

OBJS = $(ARCH)/_relocate.o dynodump.o syms.o

dynodump.so: _dynodump.h $(OBJS)
	$(CC) -o $@ -G $(OBJS) -lelf -lmapmalloc

$(ARCH)/_relocate.o: $(ARCH)/_relocate.c
	@(cd $(ARCH); $(MAKE) _relocate.o)

clean:
	rm -f *.o dynodump.so
	@(cd $(ARCH); $(MAKE) $@)

clobber: clean
	rm -f *.so *.so.1

package:
	gtar zcvf dynodump.tar.gz `cat MANIFEST`
	uuencode dynodump.tar.gz dynodump.tar.gz > dynodump.tar.gz.uu
