/* This file contains hes_postoffice, which retrieves post-office information
 * for a user.
 *
 * For copying and distribution information, see the file <mit-copyright.h>
 *
 * Original version by Steve Dyer, IBM/Project Athena.
 *
 *	$Author: ghudson $
 *	$Athena: hesmailhost.c,v 1.4 88/08/07 21:52:45 treese Locked $
 *	$Source: /afs/sipb/project/sipb-athena/src/hesiod/RCS/hesmailhost.c,v $
 *	$Log: hesmailhost.c,v $
 *	Revision 1.2  1996/06/01 18:46:32  ghudson
 *	Add reentrant interfaces.
 *
 * Revision 1.1  1995/03/18  07:04:51  ghudson
 * Initial revision
 *
 * Revision 1.6  93/10/21  14:36:09  mar
 * include string.h instead of strings.h
 * 
 * Revision 1.5  88/08/07  23:17:10  treese
 * Second-public-distribution
 * 
 * Revision 1.4  88/08/07  21:52:45  treese
 * First public distribution
 * 
 * Revision 1.3  88/06/12  00:53:06  treese
 * Cleaned up to work with Saber.
 * First public distribution.
 * 
 * Revision 1.2  88/06/05  19:51:36  treese
 * Cleaned up for public distribution
 * 
 *
 */

#include "mit-copyright.h"

#ifndef lint
static char rcsid_hesmailhost_c[] = "$Header: /afs/sipb/project/sipb-athena/src/hesiod/RCS/hesmailhost.c,v 1.2 1996/06/01 18:46:32 ghudson Exp $";
#endif

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <pwd.h>

#include "hesiod.h"

#define LINESIZE 80

extern int Hes_Errno;

struct hes_postoffice *
hes_getmailhost(user)
char *user;
{
	static struct hes_postoffice ret;
	static char linebuf[LINESIZE];
	int status;

	hes_init();
	status = hes_getmailhost_r(user, &ret, linebuf, LINESIZE);
	if (status == HES_ER_OK) {
		return(&ret);
	} else {
		Hes_Errno = status;
		return(NULL);
	}
}

int
hes_getmailhost_r(user, ret, linebuf, bufsize)
char *user, *linebuf;
struct hes_postoffice *ret;
int bufsize;
{
	char *p, *cp[2];
	int status;

	status = hes_resolve_r(user, "pobox", cp, 2);
	if (status != HES_ER_OK)
		return(status);
	if (*cp == NULL)
		return(HES_ER_INVAL);
	if ((int) strlen(*cp) > bufsize - 1) {
		free(*cp);
		return(HES_ER_RANGE);
	}
	strcpy(linebuf, *cp);
	free(*cp);
	ret->po_type = linebuf;
	p = linebuf;
	while(!isspace(*p)) p++;
	*p++ = '\0';
	ret->po_host = p;
	while(!isspace(*p)) p++;
	*p++ = '\0';
	ret->po_name = p;
	return(HES_ER_OK);
}
