#include <stdio.h>
#include <pwd.h>
#include <unistd.h>

static unsigned char saltchars[] =
	"./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

int main(int argc, char **argv)
{
    char *pass, cpass[20], salt[2];
    long r;

    if (argc != 2) {
	fprintf(stderr, "Usage: %s prompt");
	exit(1);
    }

    while (1) {

	/* Pick a random salt. */
	r = random();
	salt[0] = saltchars[r & 0x3f];
	salt[1] = saltchars[(r >> 6) & 0x3f];

	/* Get the password. */
	pass = getpass(argv[1]);
	strcpy(cpass, crypt(pass, salt));
	memset(pass, 0, strlen(pass));

	/* Verify the password. */
	pass = getpass("Please enter the same password again: ");
	if (strcmp(cpass, crypt(pass, salt)) == 0) {
	    memset(pass, 0, strlen(pass));
	    break;
	}
	memset(pass, 0, strlen(pass));
	fprintf(stderr, "The passwords did not match; please try again.\n\n");
    }

    puts(cpass);
    return 0;
}

