/*
 * $Source: /local/cvsfiles/kerberos/src/lib/des/key_sched.c,v $
 * $Author: eichin $
 *
 * Copyright 1985, 1986, 1987, 1988 by the Massachusetts Institute
 * of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * This routine computes the DES key schedule given a key.  The
 * permutations and shifts have been done at compile time, resulting
 * in a direct one-step mapping from the input key to the key
 * schedule.
 *
 * Also checks parity and weak keys.
 *
 * Watch out for the subscripts -- most effectively start at 1 instead
 * of at zero.  Maybe some bugs in that area.
 *
 * DON'T change the data types for arrays and such, or it will either
 * break or run slower.  This was optimized for Uvax2.
 *
 * In case the user wants to cache the computed key schedule, it is
 * passed as an arg.  Also implies that caller has explicit control
 * over zeroing both the key schedule and the key.
 *
 * All registers labeled imply Vax using the Ultrix or 4.2bsd compiler.
 *
 * Originally written 6/85 by Steve Miller, MIT Project Athena.
 */

#ifndef	lint
static char rcsid_key_sched_c[] =
"$Header: /local/cvsfiles/kerberos/src/lib/des/key_sched.c,v 1.4 1993/02/20 05:11:11 eichin Exp $";
#endif	lint

#include <mit-copyright.h>
#include "des_internal.h"
#include <stdio.h>

#include "des.h"

extern int des_debug;
extern rev_swap_bit_pos_0();

typedef char key[64];
/* the following are really void but cc86 doesnt allow it */
extern int des_make_key_sched();


int
des_key_sched(k,schedule)
    register des_cblock k;
    des_key_schedule schedule;
{
    if (!des_check_key_parity(k))	/* bad parity --> return -1 */
	return(-1);


    /* check against weak keys */

    if (des_is_weak_key(k))
	return(-2);

    make_key_sched(k,schedule);

    /* if key was good, return 0 */
    return 0;
}

