/*
 * $Source: /local/cvsfiles/kerberos/src/lib/krb/get_krbrlm.c,v $
 * $Author: eichin $
 *
 * Copyright 1985, 1986, 1987, 1988 by the Massachusetts Institute
 * of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 */

#ifndef lint
static char *rcsid_get_krbrlm_c =
"$Header: /local/cvsfiles/kerberos/src/lib/krb/get_krbrlm.c,v 1.3 1993/01/05 23:22:22 eichin Exp $";
#endif /* lint */

#include <mit-copyright.h>
#include <stdio.h>
#include <krb.h>
#include <string.h>

/*
 * krb_get_lrealm takes a pointer to a string, and a number, n.  It fills
 * in the string, r, with the name of the nth realm specified on the
 * first line of the kerberos config file (KRB_CONF, defined in "krb.h").
 * It returns 0 (KSUCCESS) on success, and KFAILURE on failure.  If the
 * config file does not exist, and if n=1, a successful return will occur
 * with r = KRB_REALM (also defined in "krb.h").
 *
 * NOTE: for archaic & compatibility reasons, this routine will only return
 * valid results when n = 1.
 *
 * For the format of the KRB_CONF file, see comments describing the routine
 * krb_get_krbhst().  This will also look in KRB_FB_CONF is
 * ATHENA_CONF_FALLBACK is defined.
 */

krb_get_lrealm(r,n)
    char *r;
    int n;
{
    FILE *cnffile, *fopen();

    if (n > 1)
	return(KFAILURE);  /* Temporary restriction */

#ifdef ATHENA_CONF_FALLBACK
    if (((cnffile = fopen(KRB_CONF,"r")) == NULL) &&
	((cnffile = fopen(KRB_FB_CONF,"r")) == NULL)) {
#else
    if ((cnffile = fopen(KRB_CONF,"r")) == NULL) {
#endif
	if (n == 1) {
	    (void) strcpy(r, KRB_REALM);
	    return(KSUCCESS);
	}
	else
	    return(KFAILURE);
    }

    if (fscanf(cnffile,"%s",r) != 1) {
        (void) fclose(cnffile);
        return(KFAILURE);
    }
    (void) fclose(cnffile);
    return(KSUCCESS);
}
