/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.bin/olh/ascii/RCS/get_token.c,v $
 *	$Id: get_token.c,v 1.2 92/04/05 17:08:35 probe Exp $
 *	$Author: probe $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.bin/olh/ascii/RCS/get_token.c,v 1.2 92/04/05 17:08:35 probe Exp $";
#endif
#endif

#include "olh.h"

int
  get_token( prompt_string )
char* prompt_string;
{
  int token = TOKEN_NONE;
  int number_token;
  char ch;
  int in_suggest = 0;
  int in_file= 0;
  int arrow = 0;
  
  current_prompt = prompt_string;
  paint_prompt( );
  
  while (token == TOKEN_NONE)
    {
      wrefresh(win_prompt);
      ch = wgetch(win_prompt);
      erase_message();
      
      switch (ch)
	{
	case ESC:
	  arrow++;
	  break;

	case '[':
	  arrow++;
	  break;

	case 'A':
	  if (arrow) {
	    arrow = 0;
	    token = TOKEN_SEL_PREV;
	  }
	  break;

	case 'b':
	case 'B':
	  if (arrow) {
	    arrow = 0;
	    token = TOKEN_SEL_NEXT;
	    break;
	  }
	  if (in_suggest)
	    token = TOKEN_BUG;
	  else
	    token = TOKEN_ABOVE;
	  break;

	case 'C':
	case 'c':
	  if (arrow) {
	    arrow = 0;
	    if (selection != 0)
	      token = TOKEN_CURR;
	    break;
	  }
	  if (in_suggest)
	    token = TOKEN_SUGGEST;
	  else if (in_file)
	    token = TOKEN_COPY;
	  else
	    token = TOKEN_OLC;
	  break;

	case 'D':
	  if (arrow) {
	    arrow=0;
	    token  = TOKEN_UP;
	  }
	  break;

	case 'i':
	case 'I':
	  if (in_file) 
	    token = TOKEN_INFO;
	  break;

	case 'k':
	case 'K':
	  token = TOKEN_KEYWORD;
	  break;

	case 'n':
	case 'N':
	  token = TOKEN_NEXT;
	  break;

	case 'o':
	case 'O':
	  current_prompt = "PRINT (p), COPY (c), or show INFO (i): ";
	  paint_prompt();
	  in_suggest = 0;
	  in_file = 1;
	  break;

	case 'p':
	case 'P':
	  if (in_file)
	    token = TOKEN_PRINT;
	  else
	    token = TOKEN_PREV;
	  break;

	case 's':
	case 'S':
	  current_prompt = "Send COMMENT (c) or BUG REPORT (b): ";
	  paint_prompt();
	  in_suggest = 1;
	  break;

	case 't':
	case 'T':
	  token = TOKEN_TOP;
	  break;

	case 'w':
	case 'W':
	  token = TOKEN_SHOW_PATH;
	  break;

	case 'V':
	case 'v':
	case '.':
	case RETURN:
	case NEWLINE:
	  if (selection)
	    token = TOKEN_CURR;
	  break;
	  
	  
	case CTRL_L:
	  wrefresh(curscr);
	  break;
	  
	case 'u':
	case 'U':
	case CTRL_B:
	  token = TOKEN_UP;
	  break;
	  
	case '-':
	case DELETE:
	  token = TOKEN_ABOVE;
	  break;
	  
	case '+':
	case ' ':
	  token = TOKEN_BELOW;
	  break;
	  
	case '?':
	case 'h':
	  token = TOKEN_HELP;
	  break;
	  

	case '=':
	  token = TOKEN_SHOW_VERSION;
	  break;

	case 'q':
	case CTRL_C:
	  if (in_suggest || in_file) { 
	    in_suggest = 0;
	    in_file = 0;
	    current_prompt = prompt_string;
	    paint_prompt();
	  }
	  else
	    token = TOKEN_EXIT;
	  break;
	  
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	  if ((number_token = get_number(ch)) != TOKEN_NONE)
	    token = number_token;
	  break;
	  
	case CTRL_U:
	  break;
	  
	default:
	  current_prompt = prompt_string;
	  paint_prompt( );
	  sound_bell();
	}
    }
  
  if (!((token == TOKEN_SEL_NEXT) || (token == TOKEN_SEL_PREV)))
    wclear(win_prompt);
  wrefresh(win_prompt);
  return token;
}

