/*
 *  makepath.c -- check a list of directory names for actual unique
 *		  directories and output them in a PATH format.
 *
 *  (C) 1995 Salvatore Valente <svalente@mit.edu>
 *  May be distributed and modified under the terms of the GPL.
 *  So what else is new?
 *
 */

#define _POSIX_SOURCE 1

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct file_id {
    dev_t device;
    ino_t inode;
};

int main (int argc, char *argv[])
{
    int x, y, size;
    struct file_id *fid;
    struct stat st;
    char colon;

    fid = (struct file_id *) malloc (sizeof (struct file_id) * argc);
    colon = ':';
    size = 0;
    x = 1;
    if (! strcmp (argv[x], "-s")) {
	colon = ' ';
	x++;
    }
    for (; x < argc; x++)
	if ((stat (argv[x], &st) == 0) && (S_ISDIR (st.st_mode))) {
	    for (y = 0; y < size; y++)
		if ((fid[y].device == st.st_dev) &&
		    (fid[y].inode == st.st_ino))
		    break;
	    if (y >= size) {
		if (size > 0)
		    putchar (colon);
		fputs (argv[x], stdout);
		fid[size].device = st.st_dev;
		fid[size].inode = st.st_ino;
		size++;
	    }
	}
    putchar ('\n');
    free (fid);
    return (0);
}
