#include <stdio.h>
#include <sys/file.h>
#include <sys/fcntl.h>

main(int argc, char *argv[])
{
  int fd;

  if (argc != 2)
    {
      fputs("usage: fsync filename\n", stderr);
      return 1;
    }
#ifdef _AIX
  fd = open(argv[1], O_RDWR);
#else
  fd = open(argv[1], O_RDONLY);
#endif

  if (fd == -1)
    {
      perror("open");
      return 2;
    }

  if (fsync(fd) == -1)
    {
      perror("fsync");
      return 3;
    }
  return 0;
}
