/* do_pgpsign.c --
 *
 * This is the function that will actually do the PGP signing.  It
 * will take the appropriate inputfile, outputfile, and tcp socket
 * and will perform the protocol.
 *
 * It will also return values as appropriate
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/do_pgpsign.c,v $
 * $Author: warlord $
 *
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

int
pgpsign(char **key, int *keylen, FILE *infile, FILE *outfile, int sock)
{
  int retval;

  /* Check args */
  assert (key != NULL);
  assert (infile != NULL);
  assert (outfile != NULL);
  assert (sock >= 0);

  /* Read in PGP key */
  readkeyfromfile(key, keylen, infile);

  /* Send Key to server */
  sendkey(*key, *keylen, 0, sock);
  free(*key);

  /* Receive response from server */  
  recvkey(key, keylen, &retval, sock);

  /* Write out key if it is ok */
  if (!retval)
      writekeytofile(*key, *keylen, outfile);

  return retval;
}

