/* getserver.c --
 *
 * Find the PGP Signer server, and then try to find the PGP Signer port,
 * Set the passed-in hostent and Port numbers to the appropriate values
 * and return zero on success.  Return -1 on error.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/getserver.c,v $
 * $Author: warlord $
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

int
getserver(struct hostent **hp, int *port)
{
  struct servent *sp;
  char **serverp = NULL, *server;

  /* Check Args */
  assert (hp != NULL);
  assert (port != NULL);

  /* First, try to get the hostname */
#ifdef HESIOD
  if ((serverp = hes_resolve(PGPSIGNSERV, "sloc")) != NULL && 
      *serverp == NULL) {
    /* Well, we got a response but no useful data, 
       destroy it here and now */
    free(serverp);
    serverp = NULL;
  }
#endif

  if (serverp == NULL)
    server = PGPDEFSIGNHOST;
  else
    server = *serverp;

  if ((*hp = gethostbyname(server)) == NULL) {
    fprintf(stderr, "Cannot resolve host: %s", server);
    return -1;
  }
  
  if ((sp = getservbyname(PGPSIGNPORTNAME, "tcp")) == NULL) {
    *port = htons(PGPSIGNPORT);
  } else {
    *port = sp->s_port;
  }
  
  return 0;
}

