/* pgpsign.h --
 *
 * This file contains some site definitions.  Anything changed at the
 * top is ok.  You shoudn't need to change anything below the line.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/pgpsign.h,v $
 * $Author: warlord $
 */

#include "warlord-copyright.h"

#ifndef _PGPSIGN_H
#define _PGPSIGN_H

/* This is the default host that will be used if Hesiod is not successful */
#define PGPDEFSIGNHOST "rfa.mit.edu"

/* These are for the server.  If you are not building a server, then
 * you don't have to worry about these values.
 */

/* This is the location of the PGP program on the server */
#define PGPPROG "/var/pgpsign/bin/pgp"

/* This is the location of the password for the secret key on the server */
#define PASSFILE "/var/pgpsign/control/passphrase"

/* This is the location of the srvtab file for the pgpsigner Kerberos key */
#define PGPSRVTAB "/var/pgpsign/control/srvtab"

/* This is the PGPPATH for the server; the directory where the secret
 * and public keys are kept
 */
#define PGPPATH "/var/pgpsign/keyring"

/* This is a NULL-terminated list of valid Kerberos realms.  These are
 * the realms that this server will accept and sign.  (Future versions
 * of pgpsign may move this information into a configuration file).
 */
#define KRB_REALM_LIST {"ATHENA.MIT.EDU", ""}

/* This is a NULL-terminated list of lists of mail hosts.  The first entry
 * in the list is the Kerberos realm (listed above), and the following
 * strings in the list are the valid mail hosts for that kerberos realm.
 * In this manner, it is possible to have a single keysigner sign
 * keys for multiple kerberos realms, and allow each kerberos realm
 * to specify the list of valid mail hosts.
 *
 * E.g., warlord@ATHENA.MIT.EDU can get keys signed for
 * <warlord@Athena.MIT.EDU> and <warlord@MIT.EDU>
 *
 * Note: Mail hosts are case-insensitive.
 */
#ifdef PGPSIGND

static char *REALM1[] = {"ATHENA.MIT.EDU", "Athena.MIT.EDU", "MIT.EDU", ""};
static char *NULL_REALM[] = {""};

#define MAIL_REALM_LIST \
{ \
 REALM1, \
 NULL_REALM, \
}

#endif /* PGPSIGND */   

/**********************************************************/
/* You should not have to change anything below this line */

#define PGPSIGNSERV "pgpsigner"	/* Hesiod Service Name */
#define PGPSIGNPORTNAME "pgpsigner" /* Service Port name */
#define PGPSIGNPORT 2792	/* default port number */
#define PGPSERVICE "pgpsigner"	/* Kerberos service name */

#define MAXKEYSIZE 65536	/* Why would a key be more than 64kbytes? */
#define KEYTOBIG "Unreasonable key size!  Must be less than 65536 bytes"

#define AUTHTYPELEN 8		/* 8-byte auth type */
#define AUTHTYPEKRB4 "AuthKv4"	/* Krb V4 auth-type */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <syslog.h>
#include <assert.h>

#include <krb.h>
#include <des.h>

#ifdef HESIOD
#include <hesiod.h>
#endif

#ifdef HAVE_MEMSET
#define bzero(s, l) memset(s, 0, l)
#define bcopy(s1, s2, l) memcpy(s2, s1, l)
#endif

char *whoami;		/* Program name */

/* Common functions */
void readkeyfromfile(char **key, int *keylen, FILE *fp);
void writekeytofile(char *key, int keylen, FILE *fp);
void sendkey(char *key, int keylen, int val, int sock);
void recvkey(char **key, int *keylen, int *retval, int sock);

/* Client functions */
int getserver(struct hostent **hp, int *port);
int serverconnect(struct hostent *hp, int port, char *authtype);
int pgpsign(char **key, int *keylen, FILE *infile, FILE *outfile, int sock);

/* Server functions */
int authclient(int sock, AUTH_DAT *auth_dat);
int string_in_list(char *string, char *list[], int sense);
char **krb_realm_list(void);
char **mail_realm_list(char *krb_realm);
int pgpsignd(FILE *infile, FILE *outfile, AUTH_DAT *auth_dat);
int verify_and_sign_key(char *key, int keylen, AUTH_DAT *auth_dat, 
			char **signedkey, int *signedkeylen, 
			char **error_msg);


extern int krb_net_read();
extern int krb_net_write();
extern char *krb_realmofhost();
extern int krb_sendauth();
extern int krb_recvauth();

#endif /* _PGPSIGN_H */
