#!/usr/local/bin/perl
#  invest.pl - an extremely simple hack to help me keep track of my
#              investments.
#
#  Written by Curtis Olson.  Started September 1, 1995.
#
#  Copyright (C) 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
#  The format of an input file would be something like the following.
#  Note, fields should separated by one or more tabs.
#
# -------------------------------------------------------------------
# | # Date          Description             Shares  Unit Price
# | #-----          -----------             ------  ----------
# | #19960101       Beginning of 1996       99.265  52.18
# | #19960201       Updated value           0.000   52.66
# -------------------------------------------------------------------
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: invest.pl,v 1.3 1996/02/11 20:25:41 curt Exp $
# (Log is kept at end of this file)


$total_shares = 0;
$total_invest = 0;
$acct_value = 0;

print "                                        Price   Total\n";
print "                                New     per     Shares  Total   Total\n";
print "Date     Description            Shares  Share   Owned   Invstd  Value\n";
print "-------- ---------------------- ------  ------  ------  ------  ------\n";

while ( <> ) {
    chop($_);

    if ( m/^[ \t]*#/ ) {
	# toss the comment
    } else {
	($date, $desc, $shares, $price) = split(/\t+/, $_);
	if ( $shares < 25 ) {
	    $reinv = $shares * $price;
	    $invest = 0;
	} else {
	    $reinv = 0;
	    $invest = $shares * $price;
	}

	$total_shares += $shares;
	$total_invest += $reinv + $invest;
	$acct_value = $total_shares * $price;

        printf "%s %-22s\t%-7.3f\t%.2f\t%.3f\t%.2f\t%.2f\n", $date, $desc, 
		$shares, $price, $total_shares, $total_invest, $acct_value;
    }
}


# ----------------------------------------------------------------------------
# $Log: invest.pl,v $
# Revision 1.3  1996/02/11  20:25:41  curt
# Added report heading.
#
# Revision 1.2  1996/01/21  03:39:04  curt
# Minor addition to header docs.
#
# Revision 1.1  1996/01/21  03:34:53  curt
# Initial revision.
#
