#!/usr/local/bin/perl
#  grph-txn-list.pl - Prints a report of the transactions sorted by date
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: grph-txn-list.pl,v 1.6 1995/08/03 23:02:45 curt Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = ".";
unshift(@INC, $cbb_incl_dir);
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "flush.pl";

require "common.pl";
require "reports.pl";
require "engine.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";


%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $trans) = split(/\t/, $result, 2);
	($date, $remaining) = split(/\t/, $trans, 2);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {
            $ALLTRANS{"$key$name"} = $trans;
        }

        $result = &next_trans();
    }
}


# sort and print

$data = "/tmp/gnuplot-data.$$";
open(DATA, ">$data");

$gtotal = 0.00;

foreach $key (sort (keys %ALLTRANS) ) {
    # print $ALLTRANS{$key} . "\n";
    ($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total) =
	split(/\t/, $ALLTRANS{$key});

    $gtotal += $credit - $debit;

    print DATA "$gtotal\n";
}

close(DATA);


print "Display = '$ENV{DISPLAY}'\n\n";
print "Dismiss this window to remove the graph.\n";
print "done-graph\n";

$| = 1;                         # flush buffers after every write

open(CMD, "|gnuplot") || die "Cannot run gnuplot\n";
print CMD "plot \"$data\" with lines\n";

&flush(CMD);

$junk = <>;

close(CMD);

unlink("$data");


# ----------------------------------------------------------------------------
# $Log: grph-txn-list.pl,v $
# Revision 1.6  1995/08/03  23:02:45  curt
# Fixed a date range typo which also plagued the transaction list report.
#
# Revision 1.5  1995/07/20  02:46:53  curt
# Changes to handle multiple accounts as input.
#
# Revision 1.4  1995/07/09  04:00:42  curt
# tweaked include path
#
# Revision 1.3  1995/07/08  01:45:10  curt
# Change delimiter from ":" to "\t"
#
# Revision 1.2  1995/07/05  01:15:31  curt
# It works!!!
#
# Revision 1.1  1995/07/04  21:28:26  curt
# Added Files: grph-txn-list.pl
#   Moved this file to .../cbb/graphs/
#
