#!/usr/local/bin/perl
#  log.pl - logging functions
#
#  Written by Christopher Browne.  Started November 1, 1994.
#  Modified by Curtis Olson.
#
#  Copyright (C) 1994  Christopher B. Browne cbrowne@io.org
#  Copyright (C) 1994, 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: log.pl,v 1.5 1996/01/21 02:18:50 curt Exp $
# (Log is kept at end of this file)


# Create a log entry
sub log_txn {
    local($command_line) = @_;
    local($home) = &file_dirname($current_file);

    print DEBUG "File is $current_file\n" if debug;
    print DEBUG "logging to $home/alltxns.log\n" if $debug;

    open(LOG, ">>$home/alltxns.log");
    print LOG &log_fmt_date() . " " . $command_line . "\n";
    close(LOG);
}


# return the current date/time in log format
sub log_fmt_date {
    local($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) 
	= localtime(time);
    return sprintf("19%02d/%02d/%02d %02d:%02d:%02d", $year, $mon+1, $mday, 
	$hour, $min, $sec);
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: log.pl,v $
# Revision 1.5  1996/01/21  02:18:50  curt
# Modified Files:  categories.pl common.pl engine.pl export.pl file.pl import.pl
#                  log.pl memorized.pl reports.pl wrapper.pl
#   Updated copyright date.
#
# Revision 1.4  1995/07/09  03:24:38  curt
# Tweaked logging.
#
# Revision 1.3  1995/06/05  11:41:45  curt
# Modified Files:  Todo cbb engine.pl file.tk log.pl wrapper.pl
#   Fixed transfers between files.
#   Reworked transaction logging.
#   Added an auto-save feature.
#   Reworked .cbbrc saving and loading
#   Use '.dir' now instead of '.pag'
#
# Revision 1.2  1995/01/23  03:17:06  curt
# Fixed an off by one [order of magnitude -- not really :) ] bug in log
# printing.
#
# Revision 1.1  1994/11/01  22:39:16  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
