#!/usr/local/bin/perl
#  reports.pl - code for various reports
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994, 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: reports.pl,v 1.11 1996/01/21 02:18:52 curt Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.

$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "common.pl";


# process arguments
sub process_rep_args {
    local($fromdate, $todate) = ("all", "all");
    local($arg, $nicefrom, $niceto, $month, $day, $year, $cur_year);
    local($i, @account_list);

    $cur_year = substr(&raw_date, 0, 4);

    $i = 0;

    while ( $#ARGV >= 0 ) {
        $arg = shift(@ARGV);
        if ( substr($arg, 0 , 1) eq "-" ) {
            if ( $arg eq "-from" ) {
                $nicefrom = shift(@ARGV);

                ($month, $day, $year) = split(/\//, $nicefrom);
                $month = &pad($month);
                $day = &pad($day);
		if ( defined($year) ) {
                    $year = &pad($year);
		} else {
		    $year = $cur_year;
		}
                if ( length($year) == 2 ) {
                    $year = "19" . "$year";
                }
                $fromdate = "$year" . "$month" . "$day";

                # print "from $fromdate\n";
            } elsif ( $arg eq "-to" ) {
                $niceto = shift(@ARGV);

                ($month, $day, $year) = split(/\//, $niceto);
                $month = &pad($month);
                $day = &pad($day);
		if ( defined($year) ) {
                    $year = &pad($year);
		} else {
		    $year = $cur_year;
		}
                $year = &pad($year);
                if ( length($year) == 2 ) {
                    $year = "19" . "$year";
                }
                $todate = "$year" . "$month" . "$day";

                # print "to $todate\n";
            } elsif ( $arg eq "-to" ) {
                $niceto = shift(@ARGV);
                # print "to $todate\n";
            }
        } else {
	    @account_list[$i++] = $arg;
        }
    }

    return($fromdate, $todate, @account_list);
}


1;

# ----------------------------------------------------------------------------
# $Log: reports.pl,v $
# Revision 1.11  1996/01/21  02:18:52  curt
# Modified Files:  categories.pl common.pl engine.pl export.pl file.pl import.pl
#                  log.pl memorized.pl reports.pl wrapper.pl
#   Updated copyright date.
#
# Revision 1.10  1995/07/20  11:18:57  curt
# Spelling fixes ...
#
# Revision 1.9  1995/07/20  02:51:00  curt
# Now handles args for multiple accounts
#
# Revision 1.8  1995/07/04  23:06:33  curt
# Re-did reports.pl ... moved most everything to external programs.
#
# Revision 1.7  1995/01/23  03:23:17  curt
# Preparing for more flexible report printing.
#
# Revision 1.6  1995/01/07  01:50:50  curt
# Figured out why report balance didn't match actual balance ... included
# warning now when printing mis-entered splits.
#
# Changed splits Difference -> Sum.
#
# Revision 1.5  1994/12/20  02:44:19  curt
# Added a "by category summary report"
#
# Revision 1.4  1994/12/05  17:12:39  clolson
# Final tunups for 0.51a release.
#
# Revision 1.3  1994/11/29  13:14:53  curt
# Fixed a bug where the temporary category list was not cleared for
# subsequent reports.
#
# Revision 1.2  1994/11/28  19:46:05  clolson
# Additional work on reporting
#
# Revision 1.1  1994/11/28  18:50:20  clolson
# Began integration of reporting functions.
#
