#!/usr/local/bin/perl
#  rep-txn-by-cat.pl - Prints a report of the transactions sorted by category.
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: rep-by-cat.pl,v 1.5 1995/07/20 02:47:04 curt Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = ".";
unshift(@INC, $cbb_incl_dir);
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "common.pl";
require "reports.pl";
require "engine.pl";


($#ARGV >= 0) || die "Usage: report [ -from date ] [ -to date] accounts";


# process arguments

($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

local(%tmp_cat) = ();

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $amt = $credit - $debit;

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

            $ALLTRANS{"$key$name"} = $result;

            if ( substr($cat, 0, 1) ne "|" ) {
                $tmp_cat{$cat} .= "$key$name" . "," . $amt . ",";
            } else {
                # process split

                @splits = split(/\|/, $cat);
                shift(@splits);

                $tmp = 0;
                while ( $#splits >= 0 ) {
                    $tcat = shift(@splits);
                    $tcom = shift(@splits);
                    $tamt = shift(@splits);

                    $tmp += $tamt;

                    # print "processing $tcat $tamt\n";
                    $tmp_cat{$tcat} .= "$key$name" . "," . $tamt . ",";
                }
                if ( sprintf("%.2f", $tmp) ne sprintf("%.2f", $amt) ) {
                    printf("WARNING:  Incorrect splits in $date: $desc\n");
                    printf("    %.2f != %.2f\n\n", $tmp, $amt);
                }
            }
        }

        $result = &next_trans();
    }
}


$credit_total = 0.00;
$debit_total = 0.00;

foreach $lcat (sort keys(%tmp_cat)) {
    chop($tmp_cat{$lcat});  # Delete final comma
    print "$lcat\n";

    @keys = split(/,/, $tmp_cat{$lcat});

    $subtotal = 0.00;

    while ( $#keys >= 0 ) {
        $lkey = shift(@keys);
        $amt  = shift(@keys);

        $result = $ALLTRANS{$lkey};

        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $subtotal = $subtotal + $amt;
        if ( $amt > 0 ) {
            $credit_total = $credit_total + $amt;
        } else {
            $debit_total = $debit_total + $amt;
        }

        &format_line( $result, $amt );
    }

    printf("                                         ---------\n" );
    printf("                              Subtotal = %9.2f\n\n", $subtotal);
}

printf("                                         ---------\n" );
printf("                         Total Credits = %9.2f\n\n", $credit_total);

printf("                                         ---------\n" );
printf("                          Total Debits = %9.2f\n\n", $debit_total);

printf("                                         ---------\n" );
printf("                               Balance = %9.2f\n\n", 
       $credit_total + $debit_total);


sub format_line {
    local($result, $amt) = @_;

    local($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, $result);

    ($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    $year = substr($year, 2, 4);
    $nicedate = "$mon/$day/$year";
    $cutdesc = substr($desc, 0, 20);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

    printf("  %5s  %-8s  %-20s  %9.2f  %-1s\n",
          $check, $nicedate, $cutdesc, $amt, $cleared);
}



# ----------------------------------------------------------------------------
# $Log: rep-by-cat.pl,v $
# Revision 1.5  1995/07/20  02:47:04  curt
# Changes to handle multiple accounts as input.
#
# Revision 1.4  1995/07/09  04:00:58  curt
# tweaked include path
#
# Revision 1.3  1995/07/08  01:44:44  curt
# Change delimiter from ":" to "\t"
#
# Revision 1.2  1995/07/04  22:39:45  curt
# Miscellaneous tweaking.
#
# Revision 1.1  1995/07/04  21:27:37  curt
# Added Files: rep-by-cat-shrt.pl rep-by-cat.pl rep-txn-list.pl
#   Moved these files to .../cbb/reports
#
# Revision 1.5  1994/11/28  20:07:28  clolson
# Moved "guts" to report.pl
#
# Revision 1.4  1994/11/20  15:37:25  curt
# Tiny perl4/5 compatibility changes.
#
# Revision 1.3  1994/11/14  21:25:43  clolson
# Added -from date and -to date options.
#
# Revision 1.2  1994/11/14  20:36:01  clolson
# Started working on reports !!!
#
