/* $Id: category.h,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#ifndef CATEGORY_H
#define CATEGORY_H

#define CAT_NAME_LENGTH 50
#define CAT_FILE "categories"
#define MAX_DEFINITION_SIZE 16000
#define MAX_CATEGORIES 1000

typedef struct {
  int number;
  char name[CAT_NAME_LENGTH];
  char *definition;
} category;
  
void initCategory();
void loadCategories();
void saveCategories();
category *findCat(int num);
category *findCatWithRelativeIndex(int index, char *word);
char **categoryWindowStrings(char *res[], int maxlines, char *word);
void deleteCategory(int number);
void insertCategory(category *newcat);

#endif /* CATEGORY_H */
