/* $Id: check.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include <time.h>
#include <string.h>

#include "checkp.h"
#include "check.h"
#include "country.h"
#include "programConfig.h"

#include "str.h"
#include "window.h"
#include "date.h"

#if EXPERIMENTAL

void createCheckWidgets(void) {
  static int done=0;
  
  if(done)
    return;
  done=1;

  scShell = XtVaCreatePopupShell (
				  "scShell",
				  transientShellWidgetClass,
				  topLevel,
				  XtNtitle, "Udskriv check",
				  NULL );
  
  scForm = XtVaCreateManagedWidget(
				   "scForm",
				   formWidgetClass,
				   scShell,
				   NULL);
  
  scDatoLabel = XtVaCreateManagedWidget(
				      "scDatoLabel",
				      labelWidgetClass,
				      scForm,
				      XtNlabel, "Dato:",
				      NULL);
  
  scDatoIn = XtVaCreateManagedWidget(
				     "scDatoIn",
				     asciiTextWidgetClass,
				     scForm,
				     XtNeditType, XawtextEdit,
				     XtNwidth, DATEWIDTH,
				     XtNfromHoriz, scDatoLabel,
				     NULL);
  
  scTextIn = XtVaCreateManagedWidget(
				     "scTextIn",
				     asciiTextWidgetClass,
				     scForm,
				     XtNeditType, XawtextEdit,
				     XtNwidth, 220,
				     XtNheight, 45,
				     XtNfromVert, scDatoLabel,
				     NULL);
  
  scBelLabel = XtVaCreateManagedWidget(
				     "scBelLabel",
				     labelWidgetClass,
				     scForm,
				     XtNlabel, "Belb:" ,
				     XtNfromHoriz, scDatoIn,
				     NULL);

  scBelIn = XtVaCreateManagedWidget(
				    "scBelIn",
				    asciiTextWidgetClass,
				    scForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, 10*6+3,
				    XtNfromHoriz, scBelLabel,
				    NULL);
  
  scOk = XtVaCreateManagedWidget(
				 "scOk",
				 commandWidgetClass,
				 scForm,
				 XtNlabel, "Ok",
				 XtNfromVert, scTextIn,
				 NULL);
  
  scCancel = XtVaCreateManagedWidget(
				     "scCancel",
				     commandWidgetClass,
				     scForm,
				     XtNlabel, "Fortryd",
				     XtNfromVert, scTextIn,
				     XtNfromHoriz, scOk,
				     NULL);
  addCheckCallBack();
}

void addCheckCallBack(void) {
  XtAddCallback(scCancel, XtNcallback, ScCancel, topLevel);
  XtAddCallback(scOk, XtNcallback, ScOk, topLevel);
}

/* ========================================================== */     
void ScPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  Dimension width, height;
  String p;
  int i;
  char bel[15];
  char text[256], datoT[32];

  sprintf(datoT, "%s\n", dateString(today()));
  
  createCheckWidgets();
  
  XtVaSetValues(scDatoIn,	
		XtNstring, datoT,
		NULL);
    
  sprintf(text, "%s nr.\n%s\nNiels Chr. Larsen", getKontoName(ovfTil),
	  getKontoNr(ovfTil) );

  XtVaSetValues(scTextIn,	
		XtNstring, text,
		NULL);

  XtVaGetValues(ovfbelIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(bel,p,14);
  
  XtVaSetValues(scBelIn,	
		XtNstring, bel,
		NULL);
  
  XtTranslateCoords(ovfShell,(Position)10, (Position)10,
		    &x, &y);
  
  XtVaSetValues(scShell, XtNx, x,
		XtNy, y,
		NULL );
  
  XtSetSensitive(skrivCheck,FALSE); 
  XtPopup(scShell, XtGrabNonexclusive);
}

void ScOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char dato[128], text[128], bel[128];
  String p;

  XtVaGetValues(scDatoIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(dato,p,127);

  XtVaGetValues(scTextIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(text,p,127);

  XtVaGetValues(scBelIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(bel,p,127);
  udskrivCheck(dato, text, bel);
  
  XtPopdown(scShell);
  XtSetSensitive(skrivCheck, TRUE); 
}

void ScCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(scShell);
  XtSetSensitive(skrivCheck, TRUE); 
}

#endif /* EXPERIMENTAL */
