/* $Id: main.c,v 4.1 1995/08/10 20:37:01 lupus Exp $ */

#include <stdlib.h>
#include <stdio.h>

#include "window.h"
#include "konto.h"
#include "post.h"
#include "transNum.h"
#include "focus.h"
#include "programConfig.h"
#include "category.h"
#include "main.h"

main(int argc, char **argv)
{
  char *work_directory;
  char *focus_method;

  work_directory=getenv("XFINANSDIR");
  if(work_directory) {
    if( chdir(work_directory) )
      fprintf(stderr,"warning: can't change to directory %s\n", 
	      work_directory);
  }

  setFocusMethod(FOCUS_MOUSE);
  focus_method=getenv("XFINANSFOCUS");
  if(focus_method) {
    if( !strcmp(focus_method, "keyboard") )
      setFocusMethod(FOCUS_KEYB);
  }
  
  init();             /* initialize konto.c */
  initPost();         /* initialize post.c  */
  initTransactionNumber(); 
  initFocus();
#if CATEGORY_SUPPORT
  initCategory();
#endif
  config_default();   /* set default configuration */

  mainWindow(argc, argv); 
  /* Never here! */
}
