/* $Id: rente.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include "xfinans.h"
#include "clist.h"
#include "gregor.h"

#define HUNDRED_YEARS 36525.0

double rente(CLIST *poster, long f_dato, long s_dato,
	   double posrentefod, double negrentefod)
{
   register int t=0;
   int antal;
   int dage,i=0;
   long d1,d2;
   double sal=0.0,rent=0.0,rentialt=0.0;
   antal=poster->size;

   while( t<antal && ((struct postering *)retrieve(t+1,poster))->dato<f_dato )
      {
      sal+=((struct postering *)retrieve(t+1,poster))->bel;
      t++;
      }
   if (t==antal) {
     dage=rentedage(f_dato,s_dato);
     rent=(sal>=0) ? sal*dage*posrentefod/HUNDRED_YEARS:sal*dage*negrentefod/HUNDRED_YEARS;
     return rent;
   }

   d1=f_dato;
   while( t<antal && ((struct postering *)retrieve(t+1,poster))->dato<s_dato ) {
      d2=((struct postering *)retrieve(t+1,poster))->dato;
      dage=rentedage(d1,d2);
      rent=(sal>=0) ? sal*dage*posrentefod/HUNDRED_YEARS:sal*dage*negrentefod/HUNDRED_YEARS;
      rentialt+=rent;

      /*
      printf("  %s", dateString(d1));
      printf("   %s   %3d   %9.2f   %9.2f   %9.2f\n",
		dateString(d2),dage,sal,rent,rentialt); 
      */

      d1=((struct postering *)retrieve(t+1,poster))->dato;
      sal+=((struct postering *)retrieve(t+1,poster))->bel;
      t++;
    }
   d2=s_dato;
   dage=rentedage(d1,d2);
   rent=(sal>=0) ? sal*dage*posrentefod/HUNDRED_YEARS:sal*dage*negrentefod/HUNDRED_YEARS;
   rentialt+=rent;

   /*
   printf("  %s", dateString(d1));
   printf("   %s   %3d   %9.2f   %9.2f   %9.2f\n",
	  dateString(d2),dage,sal,rent,rentialt); 
   */

   return(rentialt);
}


