/* $Id: categoryWindow.c,v 4.3 1996/01/16 21:50:21 lupus Exp lupus $ */

#include <string.h>
#include <stdio.h>

#include "categoryWindowp.h"
#include "categoryWindow.h"
#include "xfError.h"
#include "country.h"
#include "str.h"
#include "focus.h"
#include "window.h"
#include "newCategory.h"
#include "fileView.h"
#include "category.h"
#include "programConfig.h"

#if CATEGORY_SUPPORT

#define CATEGORYWINDOW_HEIGHT 260
#define CATEGORYWINDOW_WIDTH  400

#define TRANSACTION_LIST 1
#define STATUS 2

#define PANE_HEIGHT 30
#define BUTW 55

static Widget categoryWindowShell, categoryWindowPane, 
  categoryWindowBox,    categoryWindowBox2, 
  categoryWindowClose,  categoryWindowNameLabel, categoryWindowNameInput, 
  categoryWindowFilter, categoryWindowNew, categoryWindowDelete,
  categoryWindowStatus, categoryWindowTransactionList,
  categoryWindowShowVariables, 
  categoryWindowViewp,  categoryWindowList,
  categoryDeleteConfirmShell;

static char *categoryWindowStr[MAX_CATEGORIES];
static char word[50];
static int popup=0;
static int indx=-1, npress=0;

int categoryWindowIsPopup(void) {
  return popup;
}

categoryWindowInit(void) {
  int i;
  
  word[0]=0;
  for(i=0; i<MAX_CATEGORIES; i++)
    categoryWindowStr[i]=0;
}

categoryWindowFree(void) {
  int i=0;
  while(categoryWindowStr[i] && i<MAX_CATEGORIES) {
    free(categoryWindowStr[i]);
    categoryWindowStr[i]=0;
    i++;
  }
}

void updateCategoryWindowList(void) {
  String p;

  if(!popup)
    return;  

  XtVaGetValues(categoryWindowNameInput, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(word,p,49);

  categoryWindowFree();
  XawListChange(categoryWindowList, categoryWindowStrings(categoryWindowStr,MAX_CATEGORIES,word), 0,0, TRUE);

}

void createCategoryWindowWidgets(void) {
  static int done=0;
#if EXPERIMENTAL
  Widget output_button;
#endif

  if(done)
    return;
  done=1;

  categoryWindowInit();

  categoryWindowShell = XtVaCreatePopupShell (
				      "categoryWindowShell",
				      transientShellWidgetClass,
				      topLevel,
				      XtNtitle, CATEGORY_TITLE,
				      NULL );
  
  categoryWindowPane = XtVaCreateManagedWidget(
				       "categoryWindowPane",
				       panedWidgetClass,
				       categoryWindowShell,
				       XtNheight, CATEGORYWINDOW_HEIGHT,
				       XtNwidth, CATEGORYWINDOW_WIDTH,
				       NULL);
  
  categoryWindowBox = XtVaCreateManagedWidget(
				   "categoryWindowBox",
				   boxWidgetClass,
				   categoryWindowPane,
				   NULL);

  categoryWindowClose = XtVaCreateManagedWidget(
				     "categoryWindowClose",
				     commandWidgetClass,
				     categoryWindowBox,
				     XtNlabel, CLOSE,
				     XtNwidth, BUTW,
				     NULL);

  categoryWindowNameLabel = XtVaCreateManagedWidget(
				 "categoryWindowNameLabel",
				 labelWidgetClass,
				 categoryWindowBox,
				 XtNlabel, NAME,
				 NULL);
  
  categoryWindowNameInput = XtVaCreateManagedWidget(
				     "categoryWindowNameInput",
				     asciiTextWidgetClass,
				     categoryWindowBox,
				     XtNeditType, XawtextEdit,
				     XtNwidth, 100,
				     NULL);

  categoryWindowFilter = XtVaCreateManagedWidget(
				 "categoryWindowFilter",
				 commandWidgetClass,
				 categoryWindowBox,
				 XtNlabel, FILTER_LABEL,
				 XtNwidth, BUTW,
				 NULL);
  
  categoryWindowNew = XtVaCreateManagedWidget(
				 "categoryWindowNew",
				 commandWidgetClass,
				 categoryWindowBox,
				 XtNlabel, NEW_POSTING,
				 XtNwidth, BUTW,
				 NULL);
  
  categoryWindowDelete = XtVaCreateManagedWidget(
				 "categoryWindowDelete",
				 commandWidgetClass,
				 categoryWindowBox,
				 XtNlabel, DELETE_POSTING,
				 XtNwidth, BUTW,
				 NULL);
  
  categoryWindowViewp = XtVaCreateManagedWidget(
                                  "categoryWindowViewp",
                                  viewportWidgetClass,
                                  categoryWindowPane,
                                  /* XtNheight, 65, */
                                  XtNallowVert, TRUE,
                                  NULL);
 
  categoryWindowList = XtVaCreateManagedWidget(
				       "categoryWindowList",
				       listWidgetClass,
				       categoryWindowViewp,
				       XtNlist, categoryWindowStrings(categoryWindowStr,MAX_CATEGORIES,""),
				       /* XtNheight, 65, */
				       XtNdefaultColumns, 1,
				       XtNforceColumns, TRUE,
  				       NULL);

  categoryWindowBox2 = XtVaCreateManagedWidget(
				   "categoryWindowBox2",
				   boxWidgetClass,
				   categoryWindowPane,
				   XtNmin, (Dimension)PANE_HEIGHT,
				   XtNmax, (Dimension)PANE_HEIGHT,
				   NULL);

  categoryWindowShowVariables = XtVaCreateManagedWidget(
				 "categoryWindowShowVariables",
				 commandWidgetClass,
				 categoryWindowBox2,
				 XtNlabel, VARIABLES_LABEL,
				 /* XtNwidth, BUTW, */
				 NULL);
  
  categoryWindowTransactionList = XtVaCreateManagedWidget(
				 "categoryWindowTransactionList",
				 commandWidgetClass,
				 categoryWindowBox2,
				 XtNlabel, TRANSACTION_LIST_LABEL,
				 XtNwidth, BUTW,
				 NULL);
  
  categoryWindowStatus = XtVaCreateManagedWidget(
				 "categoryWindowStatus",
				 commandWidgetClass,
				 categoryWindowBox2,
				 XtNlabel, STATUS_LABEL,
				 /* XtNwidth, BUTW, */
				 NULL);

#if EXPERIMENTAL
  output_button = XtVaCreateManagedWidget(
				 "categoryWindowOutputButton",
				 commandWidgetClass,
				 categoryWindowBox2,
				 XtNlabel, "Output",
				 /* XtNwidth, BUTW, */
				 NULL);
#endif  
  
  saveFocusInfo(categoryWindowNameInput, categoryWindowNameInput, categoryWindowPane, categoryWindowFilter, 1);
  
  XtAddCallback(categoryWindowClose, XtNcallback, CategoryWindowClose, topLevel);
  XtAddCallback(categoryWindowFilter, XtNcallback, CategoryWindowFilter, topLevel);
  XtAddCallback(categoryWindowStatus, XtNcallback, CategoryWindowStatus, topLevel);
  XtAddCallback(categoryWindowShowVariables, XtNcallback, CategoryWindowShowVars, topLevel);
  XtAddCallback(categoryWindowTransactionList, XtNcallback, CategoryWindowTransList, topLevel);
  XtAddCallback(categoryWindowList, XtNcallback, CategoryListSelectionCallBack, topLevel);
  XtAddCallback(categoryWindowNew, XtNcallback, NewCategoryPopup, topLevel);
  XtAddCallback(categoryWindowDelete, XtNcallback, CategoryWindowDelete, topLevel);
#if EXPERIMENTAL
 XtAddCallback(output_button, XtNcallback, CategoryWindowOutput, topLevel);
#endif
}


#endif

void CategoryWindowPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
#if CATEGORY_SUPPORT

  if( !popup ) {
    createCategoryWindowWidgets();

    XtPopup(categoryWindowShell, XtGrabNone);
    popup=1;
    updateMarkWithText(CATEGORYWINDOW_LABEL,popup);
    jumpTo(categoryWindowNameInput);
  }
  else {
    XtPopdown(categoryWindowShell);
    popup=0;
    updateMarkWithText(CATEGORYWINDOW_LABEL,popup);
  }

#endif
}

#if CATEGORY_SUPPORT

void CategoryWindowFilter(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  updateCategoryWindowList();
  indx=-1, npress=0;
}

static void runEngine(int outputType, int data) {
  char buf[256];
  writeAllTransactionsToFile(TRANSACTION_FILE);
  writeEngineInitFile(outputType, data);
  sprintf(buf, "sort %s | perl %s > %s", TRANSACTION_FILE, 
	  ENGINE_FILE, PERL_OUTPUT_FILE);
  system(buf);
}

void CategoryWindowStatus(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  runEngine(STATUS, 0);
  FileViewDisplay(PERL_OUTPUT_FILE, STATUS_LABEL, 0);
  unlink(TRANSACTION_FILE);
}

void CategoryWindowOutput(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  writeAllTransactionsToFile("transaction.output");
}

void CategoryWindowTransList(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  category *c;
  int i;

  i=indxOfCategorySelection();
  if(i<0) {
    xfError(ERR_DO_SELECT_CATEGORY, NONFATAL, "category window");
    return;
  }

  c=findCatWithRelativeIndex(indx, word);
  if( c ) {
    runEngine(TRANSACTION_LIST, c->number);
    FileViewDisplay(PERL_OUTPUT_FILE, c->name, 0);
    unlink(TRANSACTION_FILE);
  }
}

void CategoryWindowClose(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(categoryWindowShell);
  popup=0;
  updateMarkWithText(CATEGORYWINDOW_LABEL,popup);
}

void CategoryWindowShowVars(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  FileViewDisplay(VARIABLES_FILE_NAME, VARIABLES_LABEL, 1); 
}

int indxOfCategorySelection(void) {   /* returns -1, if none is selected */
  XawListReturnStruct *res;
  res=XawListShowCurrent(categoryWindowList);
  if( res->list_index==XAW_LIST_NONE )
    return -1;
  else
    return res->list_index;
}

static void CategoryListSelectionCallBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  category *c;
  char text[256];

  i=indxOfCategorySelection();
  if(i<0)
    return;

  if( i==indx ) {
    npress++;
  }
  else {
    indx=i;
    npress=1;
  }

  c=findCatWithRelativeIndex(indx, word);
  if( c ) {
    sprintf(text, "%d", c->number);
    SetCategory(catNumInput, catNameLabel, text);
    NewCategorySetValue(c);
  }
  
  /* if( npress>=2 ) {
    npress=0;
    indx=-1;
  } 
  else {
  }
  */
}

void CategoryWindowDelete(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  category *c;
  char text[256];

  i=indxOfCategorySelection();
  if(i<0) {
    xfError(ERR_DO_SELECT_CATEGORY, NONFATAL, "category window");
    return;
  }
  
  AskConfirmDeleteCategory();
}

static void writeEngineInitFile(int outputType, int data) {
  FILE *f;

  if( !(f=fopen(ENGINE_INIT_FILE, "w")) ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL, "can't write");
    return;
  }
  fprintf(f, "# Constants used with the $output variable\n$transactionList=1;\n$status=2;\n\n");
  fprintf(f, "$output=");

  switch(outputType) {
  case TRANSACTION_LIST:
    fprintf(f, "$transactionList;\n$showNumber=%d;\n", data);
    break;
  case STATUS:
    fprintf(f, "$status;\n");
    break;
  }


  fclose(f);
}

static void CancelCategoryDelete(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(categoryDeleteConfirmShell);
}

static void ConfirmCategoryDelete(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  category *c;

  i=indxOfCategorySelection();
  if(i<0) {
    xfError(ERR_DO_SELECT_CATEGORY, NONFATAL, "category window");
    return;
  }

  c=findCatWithRelativeIndex(i, word);  
  if( c ) {
    deleteCategory(c->number);
    updateCategoryWindowList();
    saveCategories();
  }

  XtPopdown(categoryDeleteConfirmShell);
}

static void AskConfirmDeleteCategory()
{
  Position x,y;
  Widget conform, confirm, confirmOk, confirmCancel;

  if (categoryDeleteConfirmShell == NULL)
    {
      categoryDeleteConfirmShell = XtVaCreatePopupShell (
					   "categoryconfirmShell",
					   transientShellWidgetClass,
					   topLevel,
					   XtNtitle, WARNING_TITLE,
					   NULL );
      
      conform = XtVaCreateManagedWidget(
				    "categoryconform",
				    formWidgetClass,
				    categoryDeleteConfirmShell,
				    NULL);
  
      confirm = XtVaCreateManagedWidget(
				    "categoryconfirm",
				    labelWidgetClass,
				    conform,
				    XtNlabel, WARNING_TEXT_DELETE_CATEGORY,
				    NULL);

      confirmOk = XtVaCreateManagedWidget(
				      "categoryconfirmOk",
				      commandWidgetClass,
				      conform,
				      XtNlabel, CONFIRM_LABEL,
				      XtNwidth, BUTW,
				      XtNfromVert, confirm, 
				      NULL);
      
      XtAddCallback(confirmOk, XtNcallback, ConfirmCategoryDelete, 0);

      confirmCancel = XtVaCreateManagedWidget(
					  "categoryconfirmCancel",
					  commandWidgetClass,
					  conform,
					  XtNlabel, CANCEL_LABEL,
					  XtNfromVert, confirm, 
					  XtNfromHoriz, confirmOk, 
					  NULL);
      XtAddCallback(confirmCancel, XtNcallback, CancelCategoryDelete, 0);
    }
  XtTranslateCoords(categoryWindowShell, 200, 30,
		    &x, &y);
  
  XtVaSetValues(categoryDeleteConfirmShell, 
		XtNx, x,
		XtNy, y,
		NULL );

  XtPopup(categoryDeleteConfirmShell, XtGrabNone);
}

#endif /* CATEGORY_SUPPORT */
