/* $Id: gregor.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

/* int rentedage(long,long) */

/*   Calculate the number of days between the first 
 *   and second date argument. 
 */

#include <stdlib.h>
#include "date.h"

/* rente_gregoriansk() */
/* Denne funktion er en hjlpefunktion til rentedage() */
/* Forskellen er, at rente_gregoriansk() skal have to datoer, der ligger */
/* i samme kalenderr.	*/

static int rente_gregoriansk(long dat1, long dat2)
{
   int y1,y2,m1,m2,d1,d2;
   int dage;
   static int dim[] = { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
   char t, skud;

   y1=year(dat1); y2=year(dat2);

   if(y1!=y2)
      {
      /* printf("Det skal vre samme r i de to argumenter til rente_gregoriansk()!\n"); */
      return 0;
      }

   m1=month(dat1); m2=month(dat2);
   d1=day(dat1); d2=day(dat2);

   skud = y1%4==0 && y1%100!=0 || y1%400==0;
   if ( skud ) dim[2]=29;		/* i tilflde af skudr */

   if (m1>m2)		/* fejl i data */
      return( -1 );     /* returner -1 */
   if (m1==m2)
      dage=d2-d1;
   else
      if (m1==m2-1)
	 dage=dim[m1]-d1+d2;
      else
	 {
	 dage=dim[m1]-d1;
	 m1++;
	 for( t=m1; t<m2; t++)
	    dage+=dim[t];
	 dage+=d2;
	 }

   return( dage );
}

int rentedage(dag1,dag2)
long dag1, dag2;
{
   int y1,y2,dage;
   long slutdato, startdato;
   y1=year(dag1); y2=year(dag2);
   if (y1>y2)		/* fejl i data */
      return( -1 );	/* returnr -1 */
   if (y1==y2)
      return( rente_gregoriansk(dag1,dag2) );
   if (y1==y2-1)
      {
      slutdato=makedate(y1,12,31);	/* Del op i to: resterende del af */
					/* frste r og frste del af 	  */
					/* sidste r */
      dage=rente_gregoriansk(dag1,slutdato);
      startdato=makedate(y2,1,1);
      dage+=rente_gregoriansk(startdato,dag2);
      return( ++dage );
      }
   else
      {
      slutdato=makedate(y1,12,31);
      dage=rente_gregoriansk(dag1,slutdato);
      y1++;
      while( y1<y2 )
	 {
	 dage += (y1%4==0 && y1%100!=0 || y1%400==0) ? 366:365;
	 y1++;
	 }
      startdato=makedate(y2,1,1);
      dage+=rente_gregoriansk(startdato,dag2);
      return(++dage);
      }
}
