/* $Id: window.h,v 4.5 1996/06/15 19:33:07 lupus Exp lupus $ */

#ifndef WINDOW_H
#define WINDOW_H

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h> 

#include <X11/Xaw/MenuButton.h> 
#include <X11/Xaw/SimpleMenu.h> 
#include <X11/Xaw/SmeBSB.h> 
#include <X11/Xaw/SmeLine.h> 

#define NYPOST 1
#define RETPOST 2

#define S_WIDTH 455
/* #define S_WIDTH 707 */
#define S_HEIGHT 330

#define DATEWIDTH 64
#define PERIODWIDTH 25

#define KONTO_BUTW 52
#define PLUS_BUTW  32
#define POST_BUTW KONTO_BUTW

#define X_PPOS 20
#define Y_PPOS 100

#define WINDEBUG 0

#define MAIN_MENU                1
#define CONFIG_MENU              2
#define PRINTER_MENU             3
#define DATE_FORMAT_MENU         4
#define TRANSACTION_UNIT_MENU    5
#define RECUR_UNIT_MENU          6
#define RUN_RECUR_UNIT_MENU      7
#define MAX_MENU                10  /* none of the above menu ID's
				       should exceed this */

typedef struct {
  String text;
  int active;   /* >0: normal, active entry
                  ==0: entry not shown
                 ==-1: indicates a line
                */
  int opcode;
  int menu;
  Widget button;
} menu_item;

typedef struct {
  Widget dateField;
  Widget periodLengthField;
  int menuID;
} period_call_data;

void mainWindow(int argc, char **argv);
int indxOfKontoSelection(void);
static void ValgKontoCallBack(Widget w, XtPointer client_data, 
			      XtPointer call_data);
void opdaterPostList(void);
static void KontoListSelectionCallBack(Widget w, XtPointer client_data, 
				       XtPointer call_data);
static void PostListSelectionCallBack(Widget w, XtPointer client_data, 
				       XtPointer call_data);
int indxOfPostSelection(void);
void SletPostCancel(Widget w, XtPointer client_data, XtPointer call_data);
void SletPostConfirm(Widget w, XtPointer client_data, XtPointer call_data);
void SletPostPopup(Widget w, XtPointer client_data, XtPointer call_data);

void PosteringPopup(Widget w, XtPointer client_data, XtPointer call_data);
void PostConfirm(Widget w, XtPointer client_data, XtPointer call_data);
void PostCancel(Widget w, XtPointer client_data, XtPointer call_data);
void PostClear(Widget w, XtPointer client_data, XtPointer call_data);

void NyPostConfirm(Widget w, XtPointer client_data, XtPointer call_data);
void NyPostCancel(Widget w, XtPointer client_data, XtPointer call_data);
void DagsDato(Widget w, XtPointer client_data, XtPointer call_data);
void PlusDato(Widget w, XtPointer client_data, XtPointer call_data);
void MinusDato(Widget w, XtPointer client_data, XtPointer call_data);
void PlusPeriod(Widget w, XtPointer client_data, XtPointer call_data);
void MinusPeriod(Widget w, XtPointer client_data, XtPointer call_data);
void PlusMon(Widget w, XtPointer client_data, XtPointer call_data);
void MinusMon(Widget w, XtPointer client_data, XtPointer call_data);
void IncrNum(Widget w, XtPointer client_data, XtPointer call_data);
void DecrNum(Widget w, XtPointer client_data, XtPointer call_data);
void TransNumMax(Widget w, XtPointer client_data, XtPointer call_data);

void RetPostConfirm(Widget w, XtPointer client_data, XtPointer call_data);
void RetPostCancel(Widget w, XtPointer client_data, XtPointer call_data);
void SetAmountNegative(Widget w, XtPointer client_data, XtPointer call_data);
void SetAmountPositive(Widget w, XtPointer client_data, XtPointer call_data);

void NyPostCallBack(Widget w, XtPointer client_data, XtPointer call_data);
void RetPostCallBack(Widget w, XtPointer client_data, XtPointer call_data);

void OvfPopup(Widget w, XtPointer client_data, XtPointer call_data);
void OvfConfirm(Widget w, XtPointer client_data, XtPointer call_data);
void OvfCancel(Widget w, XtPointer client_data, XtPointer call_data);
void OvfClearAll(Widget w, XtPointer client_data, XtPointer call_data);
void OvfClearText(Widget w, XtPointer client_data, XtPointer call_data);

void UdsOk(Widget w, XtPointer client_data, XtPointer call_data);
void UdsCancel(Widget w, XtPointer client_data, XtPointer call_data);
void UdsPopup(Widget w, XtPointer client_data, XtPointer call_data);

void PrinterConfigOk(Widget w, XtPointer client_data, XtPointer call_data);

void Rente(Widget w, XtPointer client_data, XtPointer call_data);
void RenteFortryd(Widget w, XtPointer client_data, XtPointer call_data);
void RenteBeregn(Widget w, XtPointer client_data, XtPointer call_data);
void RenteTilskriv(Widget w, XtPointer client_data, XtPointer call_data);
void CommitCallback(Widget w, XtPointer client_data, XtPointer call_data);

void DisplayLimitClearCallback(Widget w, XtPointer client_data, XtPointer call_data);

void updateMark(Widget w, int set);
void updateMarkNumber(int number, int set);
void updateMarkWithText(char *text, int set);
void updateMarksWithOpcode(int opcode, int set);
void updateMarkOnMenu(int opcode, int menuID, int set);
int buttonWidgetToMenuID(Widget w);

int postviewh(void);
void winSetPrintCommand(char *p);
void printCommandConfigPopup(void);
void winSetTransactionLabel();
void DateFormatSelectionOk(Widget w, XtPointer client_data, 
			   XtPointer call_data);
void FloatFormatSelectionOk(Widget w, XtPointer client_data, 
			   XtPointer call_data);
void SetCategory(Widget number, Widget name, char *catnum);

#endif
