/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: thread_status.h,v $
 * Revision 1.1.6.1  1996/04/11  11:20:16  emcmanus
 * 	Copied from mainline.ppc.
 * 	[1996/04/10  16:57:07  emcmanus]
 *
 * Revision 1.1.4.1  1995/11/23  17:37:05  stephen
 * 	first powerpc checkin to mainline.ppc
 * 	[1995/11/23  16:45:31  stephen]
 * 
 * Revision 1.1.2.3  1995/10/27  14:14:44  stephen
 * 	remove export of sr_copyin to user
 * 	[1995/10/27  13:58:20  stephen]
 * 
 * Revision 1.1.2.2  1995/10/10  15:07:15  stephen
 * 	return from apple
 * 	[1995/10/10  14:34:32  stephen]
 * 
 * 	moved srr0, srr1 to head, added sr_copyin to status
 * 
 * Revision 1.1.2.1  1995/08/25  06:49:56  stephen
 * 	Initial checkin of files for PowerPC port
 * 	[1995/08/23  15:04:50  stephen]
 * 
 * $EndLog$
 */

#ifndef	_MACH_PPC_THREAD_STATUS_H_
#define _MACH_PPC_THREAD_STATUS_H_

/*
 * ppc_thread_state is the structure that is exported to user threads for 
 * use in status/mutate calls.  This structure should never change.
 *
 * TODO : it'd be nice to provide 64 bit compatibility in this structure
 *        - need to make sure that it's understood by gdb though?
 */

#define PPC_THREAD_STATE        1
#define PPC_FLOAT_STATE         2
#define THREAD_SYSCALL_STATE	6
#define THREAD_STATE_NONE	7
	       
struct ppc_thread_state {
	unsigned int srr0;      /* Instruction address register (PC) */
	unsigned int srr1;	/* Machine state register (supervisor) */
				/* srr1 may contain SRR_SYSCALL_VAL */
	unsigned int r0;
	unsigned int r1;
	unsigned int r2;
	unsigned int r3;
	unsigned int r4;
	unsigned int r5;
	unsigned int r6;
	unsigned int r7;
	unsigned int r8;
	unsigned int r9;
	unsigned int r10;
	unsigned int r11;
	unsigned int r12;
	unsigned int r13;
	unsigned int r14;
	unsigned int r15;
	unsigned int r16;
	unsigned int r17;
	unsigned int r18;
	unsigned int r19;
	unsigned int r20;
	unsigned int r21;
	unsigned int r22;
	unsigned int r23;
	unsigned int r24;
	unsigned int r25;
	unsigned int r26;
	unsigned int r27;
	unsigned int r28;
	unsigned int r29;
	unsigned int r30;
	unsigned int r31;

	unsigned int cr;        /* Condition register */
	unsigned int xer;	/* User's integer exception register */
	unsigned int lr;	/* Link register */
	unsigned int ctr;	/* Count register */
	unsigned int mq;	/* MQ register (601 only) */

	unsigned int pad;      /* structure TODO - check these! */
};

/* This structure should be double-word aligned for performance */

struct ppc_float_state {
	double  fpregs[32];

	unsigned int fpscr_pad; /* fpscr is 64 bits, 32 bits of rubbish */
	unsigned int fpscr;	/* floating point status register */
};

/*
 * saved state structure
 *
 * This structure corresponds to the state of the user registers as saved
 * on the stack upon kernel entry (saved in pcb). On interrupts and exceptions
 * we save all registers. On system calls we only save the registers not
 * saved by the caller.
 *
 * NB: If you change this structure you must also change the KGDB stub as well.
 * 
 * TODO : not sure about the save/restore regs. Does this need to be
 *        different to ppc_thread_state?
 */

struct ppc_saved_state {
	unsigned int srr0;      /* Instruction address register (PC) */
	unsigned int srr1;	/* Machine state register (supervisor) */
				/* srr1 may contain SRR_SYSCALL_VAL */
	unsigned int r0;
	unsigned int r1;
	unsigned int r2;
	unsigned int r3;
	unsigned int r4;
	unsigned int r5;
	unsigned int r6;
	unsigned int r7;
	unsigned int r8;
	unsigned int r9;
	unsigned int r10;
	unsigned int r11;
	unsigned int r12;
	unsigned int r13;
	unsigned int r14;
	unsigned int r15;
	unsigned int r16;
	unsigned int r17;
	unsigned int r18;
	unsigned int r19;
	unsigned int r20;
	unsigned int r21;
	unsigned int r22;
	unsigned int r23;
	unsigned int r24;
	unsigned int r25;
	unsigned int r26;
	unsigned int r27;
	unsigned int r28;
	unsigned int r29;
	unsigned int r30;
	unsigned int r31;

	unsigned int cr;        /* Condition register */
	unsigned int xer;	/* User's integer exception register */
	unsigned int lr;	/* Link register */
	unsigned int ctr;	/* Count register */
	unsigned int mq;	/* MQ register (601 only) */
	unsigned int sr_copyin; /* SR_COPYIN is used for remapping */
};

/* The syscall structure is used for getstate/setstate calls. 
 * Upon a system call, the state is saved in the pcb, with a special
 * value (?)masked into the msr to indicate that not all state was saved. 
 * TODO NMGS syscall state isn't yet used
 */
struct thread_syscall_state {
	unsigned int srr0;      /* Instruction address register (PC) */
	unsigned int srr1;	/* Machine state register (supervisor) */
				/* srr1 may contain SRR_SYSCALL_VAL */
	unsigned int r0;
	unsigned int r1;
	unsigned int r2;
	unsigned int r3;
	unsigned int r4;
	unsigned int r5;
	unsigned int r6;
	unsigned int r7;
	unsigned int r8;
	unsigned int r9;
	unsigned int r10;
	unsigned int r11;
	unsigned int r12;
	unsigned int r13;
	unsigned int r14;
	unsigned int r15;
	unsigned int r16;
	unsigned int r17;
	unsigned int r18;
	unsigned int r19;
	unsigned int r20;
	unsigned int r21;
	unsigned int r22;
	unsigned int r23;
	unsigned int r24;
	unsigned int r25;
	unsigned int r26;
	unsigned int r27;
	unsigned int r28;
	unsigned int r29;
	unsigned int r30;
	unsigned int r31;

	unsigned int cr;        /* Condition register */
	unsigned int xer;	/* User's integer exception register */
	unsigned int lr;	/* Link register */
	unsigned int ctr;	/* Count register */
	unsigned int mq;	/* MQ register (601 only) */
	unsigned int pad;      /* structure TODO - check these! */
};

#if NOTYET /* TODO NMGS use reduced syscall state! */
struct thread_syscall_state {
	unsigned int srr0;      /* Instruction address register (PC) */
	unsigned int srr1;	/* Machine state register (supervisor) */

	unsigned int r1;	/* stack pointer */
	unsigned int r2;	/* GOT pointer */

	unsigned int r13;
	unsigned int r14;
	unsigned int r15;
	unsigned int r16;
	unsigned int r17;
	unsigned int r18;
	unsigned int r19;
	unsigned int r20;
	unsigned int r21;
	unsigned int r22;
	unsigned int r23;
	unsigned int r24;
	unsigned int r25;
	unsigned int r26;
	unsigned int r27;
	unsigned int r28;
	unsigned int r29;
	unsigned int r30;
	unsigned int r31;

	unsigned int cr;        /* Condition register */
	unsigned int lr;	/* Link register */
};
#endif /* NOTYET */
/*
 * Save State Flags
 */
#define	SS_INTRAP	0x01	/* State saved from trap */
#define	SS_INSYSCALL	0x02	/* State saved from system call */
#define SS_ININT	0x04	/* On the interrupt stack */
#define	SS_PSPKERNEL	0x08	/* Previous context stack pointer kernel */
#define	SS_RFIRETURN	0x10	/* Must RFI from syscall to restore
				   complete user state (i.e. sigreturn) */

#define	SS_INTRAP_POS	 31	/* State saved from trap */
#define	SS_INSYSCALL_POS 30	/* State saved from system call */
#define SS_ININT_POS	 29	/* On the interrupt stack */
#define	SS_PSPKERNEL_POS 28	/* Previous context stack pointer kernel */
#define	SS_RFIRETURN_POS 27	/* RFI from syscall */

#define PPC_THREAD_STATE_COUNT \
   (sizeof(struct ppc_thread_state) / sizeof(int))

#define PPC_FLOAT_STATE_COUNT \
   (sizeof(struct ppc_float_state) / sizeof(int))

#define PPC_SYSCALL_STATE_COUNT \
   (sizeof(struct thread_syscall_state) / sizeof(int))

/*
 * Machine-independent way for servers and Mach's exception mechanism to
 * choose the most efficient state flavor for exception RPC's:
 */
#define MACHINE_THREAD_STATE		PPC_THREAD_STATE
#define MACHINE_THREAD_STATE_COUNT	PPC_THREAD_STATE_COUNT

/*
 * Largest state on this machine:
 */
#define THREAD_MACHINE_STATE_MAX	PPC_THREAD_STATE_COUNT

#endif /* _MACH_PPC_THREAD_STATUS_H_ */
