/* string_in_list.c --
 *
 * requires list be a null-terminated list of
 * strings.  Will return 1 if string is a member of the list,
 * and 0 if the string is not a member of the list.  Can be
 * set to case insensitive by setting the third argument to 1.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/string_in_list.c,v $
 * $Author: warlord $
 *
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

int
string_in_list(char *string, char *list[], int sense)
{
  /* Check args */
  assert (string != NULL);

  while (list != NULL && *list != NULL && **list != '\0') {

    if (sense) {
      if (!strcasecmp(string, *list))
	return(1);
    } else {
      if (!strcmp(string, *list))
	return(1);
    }

    list++;
  }
  return(0);
}

