/*
 * pgpsign -- this is the client of the PGP keysigner.  It will try to
 * connect to the PGP Signer, authenticate to it via Kerberos, send the
 * pgp key (it can either extract it using PGP, or take an input filename as
 * an argument), and then wait for a response back from the server.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/pgpsign.c,v $
 * $Author: warlord $
 *
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

char *whoami;

static void usage(char *whoami) {
  fprintf(stderr, "Usage: %s [input [output]]\n", whoami);
  exit (1);
}

int
main(int argc, char *argv[])
{
  struct hostent *hp;
  int port, sock, keylen, retval;
  char *key;
  FILE *infile = stdin;
  FILE *outfile = stdout;

  whoami = argv[0];

  if (argc > 3) 
    usage(whoami);

  switch (argc) {
  case 3:
    if (*argv[2] != '-')
      outfile = fopen(argv[2], "w");
  case 2:
    if (*argv[1] != '-')
      infile = fopen(argv[1], "r");
  }

  if (infile == NULL || outfile == NULL) {
    fprintf(stderr, "%s: could not open %s file, \"%s\"\n", whoami,
	    (infile == NULL) ? "input" : "output",
	    (infile == NULL) ? argv[1] : argv[2]);
    usage(whoami);
  }

  /* Get the server */
  if (getserver(&hp, &port) != 0) {
    fprintf(stderr, "%s: Error getting host, exiting\n", whoami);
    exit(1);
  }

  /* Connect and authenticate to the server using krb4 */
  if ((sock = serverconnect(hp, port, AUTHTYPEKRB4)) < 0) {
    fprintf(stderr, "%s: Error connecting and authenticating, exiting\n", 
	    whoami);
    exit (1);
  }

  retval = pgpsign(&key, &keylen, infile, outfile, sock);

  /* Deal with the response if there was a problem */
  if (retval) {
    /* This didn't work right. */
    fprintf(stderr, "%s\n", key);
    exit (1);
  }

  exit(0);
}
