#include "utils.h"
#include "rsa.h"

void       gen_rsa_key    (rsa_private_key *k)
/* generate a valid RSA key pair */
{
  Integer phi;

  k->p = generate_prime(SIZE_OF_KEYS);
  k->q = generate_prime(SIZE_OF_KEYS);
  k->n = k->p * k->q;
  phi = (k->p -1) * (k->q -1);
  do {
    k->e = generate_random(SIZE_OF_KEYS/2);
  } while (gcd(k->e, phi) != 1);
  k->d = inverse(k->e, phi);
}

void       rsa_sign       (rsa_private_key k, signed_message *m)
/* sign a message */
{
  m->sig = exp_mod(m->msg, k.d, k.n);
}

int        rsa_check      (rsa_public_key k, signed_message m)
/* verify a signature */
{
  if (exp_mod(m.sig, k.e, k.n) == m.msg) 
    return 1;
  else
    return 0;
}
