/*
 * Gnome Attacks
 *
 * Copyright (c) 2003 by Andy Balaam
 *
 * Released under the GNU General Public License
 * with ABSOLUTELY NO WARRANTY.
 *
 * See the file COPYING for more information.
 *
 */
 
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <string.h>

#include "main.h"
#include "interface.h"
#include "support.h"
#include "game.h"
#include "graphics.h"
#include "hiscore.h"
#include "levelset.h"

int
main (int argc, char *argv[])
{
  
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif
  
  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);
  
  /* Set everything up */
  game_setup();
  levelset_setup();
  graphics_setup();
  hiscore_setup();
  
  /* Draw the GUI */
  _init_gui();

  /* Start the timers ticking */
  game_restart_titles();
  
  /* and give up control to gtk */
  gtk_main();
  
  return 0;
  
}

void _init_gui()
{
  
  app1 = NULL;
  about2 = NULL;
                    
  app1 = create_app1();
  
  gtk_widget_add_events( lookup_widget( app1, "drawingarea1" ),
    GDK_BUTTON_PRESS_MASK );
  
  appbar1       = GNOME_APPBAR( lookup_widget( app1, "appbar1" ) );
  new1          = GTK_MENU_ITEM( lookup_widget( app1, "new1" ) );
  pause_game1   = GTK_MENU_ITEM( lookup_widget( app1, "pause_game1" ) );
  restart_game1 = GTK_MENU_ITEM( lookup_widget( app1, "restart_game1" ) );
  end_game1     = GTK_MENU_ITEM( lookup_widget( app1, "end_game1" ) );
  levels1       = GTK_MENU_ITEM( lookup_widget( app1, "levels1" ) );
  
  levelset_create_menu();
  
  gtk_widget_show( app1 );
  
}

void main_quit()
{
  
  game_quit();
  levelset_quit();
  graphics_quit();
  hiscore_quit();
  
  gtk_main_quit();
  
}






