package MyWebLog::Dispatcher;
use Jifty::Dispatcher -base;

before '/' => run {
    Jifty->api->deny('MyWebLog::Action::CreateUser');
};

before '*' => run {
    my $top = Jifty->web->navigation;
    $top->child('New Entry'    => url => '/post');
    $top->child('Logout' => url => '/logout')
      if Jifty->web->current_user->id;
}

on qr{^/$} => run {
    my $posts = MyWebLog::Model::EntryCollection->new;
    $posts->unlimit;
    set posts => $posts;
    set title => "My Web Log";
    show '/post_list';
};

before '/user/#' => run {
    my $id = $1;
    my $user = MyWebLog::Model::User->new;
    $user->load($1);
    redirect '/errors/no_such_user' unless $user->id;
    set posts => $user->posts;
    set title => 'Posts by ' . $user->name;
    show '/post_list';
};

before '/post' => run {
    tangent '/login' unless Jifty->web->current_user->id;
    Jifty->api->allow('MyWebLog::Action::CreateUser');
};

on '/post' => run {
    set action => Jifty->web->new_action(
        class => 'CreateEntry');
};

before '/login' => run {
    redirect '/' if Jifty->web->current_user->id;
}

on '/login' => run {
    set 'action' => Jifty->web->new_action( class => 'Login');
    set 'next' => Jifty->web->request->continuation || 
                  Jifty::Continuation->new( request =>
                                            Jifty::Request->new( path => "/" ) );
};

on '/signup' => run {
    set 'action' => Jifty->web->new_action( class => 'Signup');
    set 'next' => Jifty->web->request->continuation || 
                  Jifty::Continuation->new( request =>
                                            Jifty::Request->new( path => "/" ) );
};

before 'logout' => run {
    Jifty->web->new_action( class => 'Logout', moniker => 'logout')->run;
    redirect '/';
};

1;
