use strict;
use warnings;

package MyWebLog::Model::Entry;
use Jifty::DBI::Schema;
use MyWebLog::Model::User;
use Regexp::Common 'profanity';

use MyWebLog::Record schema {
     column title =>
       type is 'Text',
       default is '(Untitled)';

     column body =>
       render_as 'Textarea';

     column timestamp =>
       type is 'timestamp',
       filters are qw(Jifty::DBI::Filter::DateTime),
       label is 'Posted at',
       since '0.0.2',
       is immutable;

     column author =>
       refers_to MyWebLog::Model::User,
       label is 'Posted by',
       since '0.0.4',
       is immutable;
};

# Your model-specific methods go here.

sub before_create {
   my ($self, $attr) = @_;
   $attr->{timestamp} ||= DateTime->now;
   $attr->{author} = $self->current_user->id;
};

sub validate_body {
   my $self = shift;
   my $body = shift;
   if ( $body =~ /$RE{profanity}/i) {
       return
        (0, 'Would you speak like that in front of your mother? *cough*')
   }
   return (1, "OK");
}

sub canonicalize_title {
    my $self = shift;
    my $title = shift;
    return join(" ", map {ucfirst} split/\s+/, $title);
}

sub current_user_can{
    my $self = shift;
    my $right = shift;
    my $user = $self->current_user;
    if($right eq 'read') {
        return 1;
    } elsif($right eq 'create') {
        return 1 if $user->id;
    } elsif($right eq 'delete' or $right eq 'update') {
        return 1 if $user->id == $self->author->id;
    }
    return $self->SUPER::current_user_can(
        $right, @_);
}

1;

