/*
  Copyright 2005, 2006, 2007 David Cad, Damien Stehl.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; see the file COPYING.  If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  This program implements ideas from the paper "Floating-point LLL Revisited", 
  by Phong Nguyen and Damien Stehl, in the Proceedings of Eurocrypt'2005, 
  Springer-Verlag; and was partly inspired by Shoup's NTL library: 
  http://www.shoup.net/ntl/

*/

#ifndef MATRIX_H
#define MATRIX_H

#include "nr.h"

template <class ZT>
class ZZ_mat
{
  
  int c,r;
  Z_NR<ZT> ** matrix;
 public:
  int GetNumCols(){return c;};
  int GetNumRows(){return r;};

  // generators
  void gen_intrel(int bits);
  void gen_simdioph(int bits,int bits2);
  void gen_uniform(int bits);
  void gen_ntrulike(int bits,int q);
  void gen_ntrulike2(int bits,int q);
  void gen_ajtai(double alpha);


  //utils
  ZZ_mat(int cols,int rows);
  inline Z_NR<ZT>& Get(int i,int j);
  inline void Set(int i,int j,Z_NR<ZT>& s);
  inline Z_NR<ZT>*& GetVec(int i);
  ~ZZ_mat();
  void print();
  void print(int d,int n);
  int read();
  int getMaxExp();

  int getShift();

};


template <class FT>
class FP_mat
{
  
  int c,r;
  FP_NR<FT> ** matrix;
 public:
  int GetNumCols(){return c;};
  int GetNumRows(){return r;};
  FP_mat(int cols,int rows);
  inline FP_NR<FT>& Get(int i,int j);
  inline FP_NR<FT>*& GetVec(int i);
  inline void Set(int i,int j,FP_NR<FT>& s);
  ~FP_mat();
  void print();
  void print(int d,int n);
};

#include "matrix.cpp"

#endif
