#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "termorder.h"
#include "ep_standard.h"
#include "ep_xfig.h"
#include "gfanapplication.h"
#include "wallideal.h"

class EdwinsConjectureApplication : public GFanApplication
{
  SimpleOption optionReadWeightVector;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "Program to help us test Edwin's conjecture\n";
  }
  EdwinsConjectureApplication():
    optionReadWeightVector("-w","undocumented")
  {
    registerOptions();
  }    

  char *name()
  {
    return "_edwinsconjecture";
  }

  bool inList(IntegerVector const &v,IntegerVectorList const &l)
  {
    for(IntegerVectorList::const_iterator i=l.begin();i!=l.end();i++)
      if(*i==v)return true;
    return false;
  }
  IntegerVector MatrixMultiplication(IntegerVectorList const &a, IntegerVector const &b)
  {
    IntegerVector sum(a.begin()->size());
    int j=0;
    for(IntegerVectorList::const_iterator i=a.begin();i!=a.end();i++)
      {
	sum+=(b[j])*(*i);
	j++;
      }
    return sum;
  }

  int main()
  {
    TermOrder *myOrder;

    IntegerVectorList A=FileParser(Stdin).parseIntegerVectorList();

    PolynomialSet g=FileParser(Stdin).parsePolynomialSetWithRing();
    
    IntegerVectorList gL=wallInequalities(g);

    IntegerVectorList circuits=FileParser(Stdin).parseIntegerVectorList();
    
    
    fprintf(Stderr,"Input matrix:\n");
    AsciiPrinter(Stderr).printVectorList(A);
    fprintf(Stderr,"A Groebner basis:\n");
    AsciiPrinter(Stderr).printPolynomialSet(g);
    fprintf(Stderr,"As vectors:\n");
    AsciiPrinter(Stderr).printVectorList(gL);
    fprintf(Stderr,"The circuits:\n");
    AsciiPrinter(Stderr).printVectorList(circuits);
 
    IntegerVectorList additional;
    for(IntegerVectorList::const_iterator i=gL.begin();i!=gL.end();i++)
      {
	if((!inList(*i,circuits))&&(!inList(-(*i),circuits)))
	  {
	    //	    AsciiPrinter(Stdout).printVector(*i);
	    IntegerVector degree=MatrixMultiplication(A,max(*i,*i-*i));
	    // AsciiPrinter(Stdout).printVector(degree);
	    additional.push_back(degree);
	  }
      }

    for(IntegerVectorList::const_iterator i=additional.begin();i!=additional.end();i++)
      A.push_back(*i);

    fprintf(Stderr,"New matrix:\n");
    AsciiPrinter(Stderr).printVectorList(A);
    AsciiPrinter(Stdout).printVectorList(A);
    

    return 0;
  }
};

static EdwinsConjectureApplication theApplication;

