#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "termorder.h"
#include "ep_standard.h"
#include "ep_xfig.h"
#include "gfanapplication.h"
#include "renderer.h"
#include "xfig.h"

class RenderNewtonPolytopeApplication : public GFanApplication
{
  FieldOption theFieldOption;
  SimpleOption optionListOfPolynomialSets;
  IntegerOption optionMaxEntry;
  IntegerOption optionWidth;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "Renders the Newton polytope of a polynomial in two variables.\n"
      "The output is an xfig file.\n";
  }
  RenderNewtonPolytopeApplication():
    optionListOfPolynomialSets("-m","undocumented"),
    optionMaxEntry("-d","undocumented",8),
    optionWidth("-w","undocumented",5)
  {
    registerOptions();
  }

  char *name()
  {
    return "_rendernewtonpolytope";
  }
  
  int main()
  {
    /*    LpSolver::printList(Stderr);
    lpSetSolver("cddgmp");
    */    
    FileParser P(Stdin);

    Polynomial p=P.parsePolynomialWithRing();


    XFig f(Stdout);

    int scale=1000;
    int maxX=5;
    int maxY=5;

    f.beginDrawLine(false,true);
    f.addPoint(0,0);
    f.addPoint(maxX*scale,0);
    f.endDrawLine();

    f.beginDrawLine(false,true);
    f.addPoint(0,0);
    f.addPoint(0,-maxY*scale);
    f.endDrawLine();


    for(TermMap::iterator i=p.terms.begin();i!=p.terms.end();i++)
      {
	Monomial m=i->first;

	IntegerVector v=m.exponent;
	assert(v.size()>=2);
	int x=v[0];
	int y=v[1];
	f.drawDot(scale*x,-scale*y);

	f.drawString(scale*x+int(0.2*scale),-scale*y+60,i->second.toString());
      }

    return 0;
  }
};

static RenderNewtonPolytopeApplication theApplication;
