#include "vektor.h"

IntegerVectorList transposeIntegerVectorList(IntegerVectorList const &l)
{
  int n=l.size();
  assert(n);
  int m=l.begin()->size();

  IntegerVectorList r;

  for(int i=0;i<m;i++)
    {
      IntegerVector column(n);
      
      int j=0;
      for(IntegerVectorList::const_iterator J=l.begin();J!=l.end();J++)
	{
	  column[j]=(*J)[i];
	  j++;
	}
      r.push_back(column);
    }
  return r;
}


IntegerVectorList multiplyIntegerVectorList(IntegerVectorList const &A, IntegerVectorList const &B)
{
  int s1=A.size();
  assert(s1);
  int r=A.begin()->size();
  int t=B.size();
  assert(t);
  int s2=B.begin()->size();

  assert(s1==s2);

  IntegerVectorList C;
  for(IntegerVectorList::const_iterator I=B.begin();I!=B.end();I++)
  {
    IntegerVector column(r);

    int j=0;
    for(IntegerVectorList::const_iterator J=A.begin();J!=A.end();J++)
      {
	column+=(*I)[j]*(*J);
	j++;
      }
    C.push_back(column);
  }
  return C;
}


/* Computes the greatest common divisor of two integers.
   The result is always positive.
   Asserts if both integers are zero.
 */
int gcd(int r, int s)
{
  if(r<0)r=-r;
  if(s<0)s=-s;
  
  if(s<r)
    {
      int t;
      t=r;
      r=s;
      s=t;
    }

  while(r!=0)
    {
      int t=s%r;
      s=r;
      r=t;
    }
  assert(s!=0);

  return s;
}


/* Returns positive gcd of elements in the vector.
   The result is always positive. 
   Asserts if the vector is the zero-vector.
 */
int gcdOfVector(IntegerVector const &v)
{
  int ret=0;
  for(int i=0;i<v.size();i++)if(ret=v[i])break;
  if(ret<0)ret=-ret;
  assert(ret!=0);
  for(int i=0;i<v.size();i++)ret=gcd(ret,v[i]);

  return ret;
}


/* Uses gcd to put (the direction given by) the vector in a unique form by scaling.
   Only positive scaling is applied.
   If the input is the zero-vector so is the output.
   Otherwise, the common divisor of the output is 1. 
*/
IntegerVector normalized(IntegerVector v)
{
  if(v.isZero())return v;
  int a=gcdOfVector(v);
  for(int i=0;i<v.size();i++)v[i]/=a;

  return v;
}
